### Элементы ответа

#### age
Возраст переданной куки в секундах.

#### allow_more_users
Признак того, что в текущую куку можно добавить ещё пользователей, т.е. лимит на максимальное число пользователей в куке при мультиавторизации ещё не достигнут.<br/>Возвращается в ответе только при включенном параметре [`multisession`](../../methods/sessionid.md#multisession).

#### authid
Идентификатор сессии, для которой выписана проверяемая авторизационная кука.<br/><br/>Вложенные ключи содержит идентификатор сессии, и отдельные свойства, из которых составляется идентификатор.

#### authid->time
UNIX-время авторизации пользователя.

#### authid->host
Идентификатор машины, которая сгенерировала куку.

#### authid->ip
IP-адрес, с которого авторизовался пользователь.

#### connection_id
Идентификатор соединения, по которому был авторизован пользователь. С его помощью можно закрыть авторизованное соединение, которое остается активным после удаления или блокировки аккаунта.

#### default_uid
UID активного аккаунта в куке мультиавторизации. Активным считается аккаунт, на который пользователь переключился в последний раз.<br/>Возвращается в ответе только при включенном параметре [`multisession`](../../methods/sessionid.md#multisession).

#### error
Пояснение статуса авторизации, указанного в элементе [`status`](#status). Например, при статусе авторизации «INVALID» элемент `error` может содержать значение «user has logged out globally».<br/><br/>При успешной аутентификации элементу присваивается значение «ОК».<br/><br/> Значение предназначено для внутреннего использования (например, для отладки или записи в лог). Пользователю следует сообщать об ошибке в контексте операции, которую он пытался произвести.

#### expires_in
Оставшийся срок действия куки в секундах.

#### is_reg_completion_recommended
Признак того, рекомендуется ли предложить пользователю завершить регистрацию или нет.

#### login_id
Расширенный идентификатор соединения, по которому был авторизован пользователь. В отличие от [`connection_id`](#connection_id), `login_id` сохраняется при обмене куки на токен и обратно, т.е. цепочка кук и/или токенов из одной сессии будет иметь один `login_id`.

#### special
Признак куки, которая была сгенерирована не при авторизации пользователя, а для служебного использования.<br/><br/>Поддерживаемое значение:<br/>- 2 (`STRESS`) — кука сгенерирована для стресс-тестирования. Валидной такую куку признает только [стрессовый ЧЯ](../../concepts/location.md#section_stress)

#### status
Статус авторизации (результат проверки авторизационной куки `Session_id`).<br/><br/>Если в запросе был задан параметр [`multisession`](../../methods/sessionid.md#multisession), элемент отражает общий статус куки. В противном случае — статус куки, совмещенный со статусом аккаунта по умолчанию.<br/><br/>Возможные статусы, с соответствующими числовыми идентификаторами:<br/>- 0 (`VALID`) — переданная авторизационная кука валидна. Если не задан параметр [`multisession`](../../methods/sessionid.md#multisession), этот статус также говорит о том, что аккаунт по умолчанию залогинен.<br/>- 1 (`NEED_RESET`) — аутентификационная кука **валидна**, но может быть обновлена. Процесс обновления куки описан в документе [Обзор системы авторизации](https://docs.yandex-team.ru/authdevguide/concepts/authorization-policy-resign).<br/>- 2 (`EXPIRED`) — срок действия авторизационнойкуки истек, сессия не действительна.<br/>- 3 (`NOAUTH`) — пользователь не авторизован в данном домене.<br/>Куки со статусом `NOAUTH` используются для подчиненных доменов в мультидоменной авторизации (МДА).<br/>- 4 (`DISABLED`) — учетная запись пользователя существует, но заблокирована службой поддержки (возможен только если в запросе не был задан параметр [`multisession`](../../methods/sessionid.md#multisession)).<br/>- 5 (`INVALID`) — авторизационная кука неправильного формата, была сформирована до выхода или проверяется не в том окружении, для которого была выставлена.<br/>Если в запросе не был задан параметр [`multisession`](../../methods/sessionid.md#multisession), статус также может означать, что для аккаута был выполнен выход на всех устройствах, необходимо сменить пароль, или аккаунта не существует.<br/>- 8 (`WRONG_GUARD`) — кука `sessguard` невалидна или отсутствует. [Пользователя нужно отправить на обновление куки.](../../concepts/sessguard.md#obnovlenie-sessguard)


#### ttl
Тип сессии. Возможные значения:<br/>- 0 — короткая (максимальный срок жизни куки — 2 часа);<br/>- 5 — длинная (максимальный срок жизни куки — 90 дней). Сохраняется при закрытии браузера.<br/><br/>Неиспользуемые значения:<br/>- 1 — старая длинная сессия;<br/>- 2 — короткая сессия в подчиненных доменах;<br/>- 3 — старая двухнедельная сессия;<br/>- 4 — короткая в `yandex-team.ru` (максимальный срок жизни куки — 4 часа).

#### user(s)
В XML - элемент с данными об одной из учетных записей. В JSON - массив данных об учетных записях, указанных в переданной куке `Session_id`.<br/>Возвращается только если в запросе передан параметр [multisession](../../methods/sessionid.md#multisession).

#### user->status
Статус авторизации аккаунта, описанного в данном элементе `user`.<br/><br/>Возможные статусы, с соответствующими числовыми идентификаторами:<br/>- 0 (`VALID`) — аккаунт существует и залогинен.<br/>- 1 (`NEED_RESET`) — авторизационная кука может быть обновлена. Выставляется, если в элементе `status` выше уровнем также указан статус `NEED_RESET`.<br/>- 4 (`DISABLED`) — учетная запись заблокирована службой поддержки.<br/>- 5 (`INVALID`) — либо аккаунт не существует, либо сессия по какой-либо причине не валидна.

#### user->auth
Дополнительные данные об аутентификации.

#### user->auth->password_verification_age
Время в секундах, прошедшее с момента последней успешной аутентификации пользователя по логину и паролю.<br/><br/>Значение −1 говорит о том, что пароль не вводился. Например, пароль не требуется вводить при социальной авторизации, подробнее см. вики: [https://wiki.yandex-team.ru/passport/social/about](https://wiki.yandex-team.ru/passport/social/about).

#### user->auth->social
Признак социальной авторизации. Если пользователь вошел на Яндекс через социальную сеть, в этом элементе ответа указывается идентификатор социального профиля, который был использован.<br/><br/>Подробнее о социальной авторизации см. вики: [https://wiki.yandex-team.ru/passport/social/about](https://wiki.yandex-team.ru/passport/social/about).

#### user->auth->social->profile_id
Идентификатор социального профиля. Соответствует учетной записи на социальном сервисе, с помощью которой была проведена социальная авторизация.

#### user_ticket
User-тикет пользователя.<br/><br/>Включается в ответ, если был передан параметр [`get_user_ticket`](../../methods/sessionid.md#get_user_ticket), в заголовке [`X-Ya-Service-Ticket`](../../methods/sessionid.md#x-ya-service-ticket-header) был указан правильный Service-тикет и проверка сессии прошла успешно.<br/> User-тикет, возвращаемый в методе [`sessionid`](../../methods/sessionid.md) может содержать сразу несколько UID-ов, но содержит информацию только о пользователях со [статусами](../../methods/sessionid.md#status) `VALID`(0) или `NEED_RESET`(1), т.е. для которых сессия проверена успешно.
