# Ошибки обращения к Черному ящику

Как правило, даже если на стороне Черного ящика произошла ошибка, код состояния ответа на HTTP-запрос равен 200, а описание ошибки содержится в теле ответа. Список таких ошибок и действия, которые необходимо предпринимать в случае их возникновения, приведены в разделе [Ошибки Черного ящика](#processing).

Ряд ошибок требует повторения запроса (ретрая). Список таких ошибок и правила отправки повторного запроса приведены в разделе [Повторные запросы](#retries-policy).

В общем случае схема обработки ответа Черного ящика должна выглядеть примерно так:
1. Проверяем HTTP код ответа, если это не 200, это точно ошибка, возможно вы ошиблись в хосте или запросе.
1. Если код ответа 200, нужно проверить, является ли ответ сообщением об ошибке (пример: [xml](#XML), [json](#JSON))
1. Если это ответ об ошибке, то в зависимости от кода ошибки может потребоваться ретрай (см [повторные запросы](#retries-policy))
1. В остальных случаях нужно разбирать формат ответа конкретного метода, проверять статус (если он есть, как в методах [oauth](../methods/oauth.md) или [sessionid](../methods/sessionid.md) и дальше уже смотреть на возвращаемые данные.

{% note warning %}

Если вы не проверили код ответа и возможную ошибку обработки запроса не следует делать каких-то продуктовых выводов, например, что сессия была не валидна или у пользователя отсутствует подписка на сервис или не привязан телефон.

{% endnote %}


## Ошибки Черного ящика {#processing}

При возникновении ошибки Черный ящик прекращает обработку запроса и возвращает ответ, содержащий идентификатор ошибки и ее описание.

Идентификаторы ошибок определены в файле [session_errors.h](https://a.yandex-team.ru/arc/trunk/arcadia/library/cpp/blackbox2/session_errors.h). В таблице ниже перечислены наиболее часто встречающиеся на практике коды ошибок.

Текстовый код ошибки | Числовой код ошибки | Комментарий
----- | ----- | -----
`OK` | `0` | Ошибок не обнаружено.
`INVALID_PARAMS` | `2` | Неправильно указан или отсутствует обязательный аргумент. Проверьте, что запрос был составлен корректно.
`DB_EXCEPTION` | `10` | Ошибка обращения к базе, [повторите запрос](#retries-policy).
`ACCESS_DENIED` | `21` | Отсутствуют [гранты](../concepts/getting-access.md) на метод, параметр метода или на запрашиваемое поле в аргументе `dbfields`. Проверьте, что у вас присутствуют все необходимые гранты.
`UNKNOWN` | `1` | Прочие ошибки.

Формат документа, возвращаемого при возникновении ошибки, не зависит от исполняемого метода. Узнать тип возникшей ошибки можно по идентификатору, возвращаемому в ответе.

## XML-ответ об ошибке {#XML}

Описание ошибки возвращается в виде XML-документа, если в запросе не был задан параметр `format`. Пример возвращаемого XML-документа:

```xml
<?xml version="1.0" encoding="utf-8"?>
<doc>
  <exception id="2">INVALID_PARAMS</exception>
  <error>Missing userip argument</error>
</doc>
```

Ответ состоит из следующих элементов:
#### exception

```xml
<exception id="2">INVALID_PARAMS</exception>
```
Присутствие элемента `exception` является признаком ошибки. Значение элемента — текстовый идентификатор ошибки (в приведенном примере — «INVALID_PARAMS»).
#### id
Числовой идентификатор ошибки.

#### error

```xml
<error>Missing userip argument</error>
```

Текстовое описание ошибки.

{% note warning %}

Описание ошибки предназначено только для внутреннего использования (например, для отладки или записи в лог), его нельзя показывать пользователю!
Пользователю следует сообщать об ошибке в контексте операции, которую он пытался произвести.

{% endnote %}

## JSON-ответ об ошибке {#JSON}
Описание ошибки возвращается в виде JSON-документа, если в запросе был задан параметр `format` со значением «json». Пример возвращаемого JSON-документа:
```no-highlight
{
  "exception":
  {
    "value":"INVALID_PARAMS",
    "id":2
  },
  "error":"BlackBox error: Missing userip argument"
}
```

Ответ состоит из следующих элементов:
#### exception (Object)

```no-highlight
"exception":
{
  "value":"INVALID_PARAMS",
  "id":2
}
```
Присутствие объекта `exception` является признаком ошибки.
#### value (String)
Текстовый идентификатор ошибки.
#### id (Number)
Числовой идентификатор ошибки.

#### error

```no-highlight
"error":"BlackBox error: Missing userip argument"
```

Текстовое описание ошибки.

{% note warning %}

Описание ошибки предназначено только для внутреннего использования (например, для отладки или записи в лог), его нельзя показывать пользователю!
Пользователю следует сообщать об ошибке в контексте операции, которую он пытался произвести.

{% endnote %}

## Повторные запросы {#retries-policy}

Отправьте повторный запрос к ЧЯ, если:

- Ответ Черного ящика содержит HTTP код `5xx`.

- Ответ Черного ящика содержит HTTP код `200`, а тело ответа содержит описание [ошибки типа DB_EXCEPTION](blackboxErrors.md#processing).

- Запрос к Черному ящику завершился по таймауту. Рекомендуемое значение таймаута (с момента отправки в ЧЯ последнего байта запроса) — 50 мс.

- Запрос закончился ошибкой TCP/TLS.

Перед ретрем запроса в черный ящик необходимо закрыть старое TCP-соединение.

Если вы отправляете большое количество запросов из фоновой задачи, рекомендуемое значение таймаута перед повторным запросом — 100 мс.

Рекомендуемое количество повторных попыток — 3. Если после третьего ретрая Черный ящик не ответил корректно, сервисам рекомендуется считать запрос неудачным и предпринимать соответствующие действия. Например, переключать сценарии использования на незалогиновые или выводить сообщение об ошибке.
