# Получение e-mail адресов пользователя

С каждым пользовательским аккаунтом может быть связано некоторое количество e-mail адресов.
Адресов может быть неограниченно большое количество, а может не быть вообще.

E-mail адреса разделяются на две группы - нативные адреса аккаунта и внешние адреса.

#### Нативные адреса {#native}

Если у аккаунта есть почтовый ящик на Яндексе (подписка на сервис Яндекс.Почта), то адреса, принадлежащие этому ящику, мы называем нативными.
Чаще всего (но не всегда!) нативные адреса это адреса вида `username@yandex.ru`, `username@yandex.com` и т.п.

Нативные адреса нигде не хранятся, они генерируются Черным ящиком по списку поддерживаемых почтовых доменов в зависимости от страны пользователя.
Так, например, адреса вида `username@yandex.com.tr` видны только пользователям из Турции, а `username@yandex.fr` - пользователям из Франции.
При этом на доставку почты работают адреса из всех поддерживаемых доменов, даже если они не видны в списке.
Список доменов может изменяться со временем, а также меняться список видимых адресов при изменении страны пользователя в базе, поэтому не нужно закладываться на наличие конкретных адресов в списке.
Также не нужно закладываться на то, что логинная часть адреса совпадает с логином, т.к. возможны исключения.

Т.к. почтовый ящик любого аккаунта может быть удален самим пользователем или заморожен, то нативных адресов у пользователя может не быть.

В ответе Черного ящика нативные адреса помечены флагом `native`.

#### Внешние адреса {#external}

Помимо своего ящика на Яндексе и связанных с ним e-mail-ов пользователь может привязать к своему аккаунту произвольное число дополнительных адресов.
Такие адреса мы называем внешними. Это могут быть адреса на других почтовых сервисах или адреса на Яндексе, принадлежащие другому аккаунту. Свой нативный адрес привязать нельзя.
Внешние адреса можно так же, как и нативные, использовать для отправки писем или получения уведомлений, но кроме этого они могут использоваться для восстановления доступа к аккаунту.

Внешние адреса хранятся в расширенных атрибутах аккаунта и могут иметь разные свойства.
* `validated` - подтвердил ли пользователь владение этим адресом. Фактически, для адреса без флага `validated` принадлежность пользователю не известна, адрес может принадлежать постороннему человеку.
* `unsafe` - адрес был добавлен без дополнительного подтверждения паролем (например, через вызов АПИ) и не может использоваться для критичных операций, таких как восстановление доступа.
* `silent` - адрес не может использоваться для отправки на него информационных рассылок и уведомлений, разрешены только критически важные письма.
* `rpop` - на этот внешний адрес настроен сборщик почты, т.е. адрес принадлежит пользователю, но восстанавливать доступ через него нельзя.

Управление внешними адресами осуществляется через [интерфейс Паспорта](https://passport.yandex.ru/profile/emails)
Внешних адресов, так же, как и нативных, может не быть ни одного.

Для получения информации о e-mail адресах пользователя есть два способа:
* высокоуровневый, через аргумент [emails](#emails)
* низкоуровневый, чтение почтовых атрибутов аккаунта через аргумент [getemails](#getemails)

## Аргумент emails {#emails}

Рекомендуемый способ получения информации о e-mail адресах пользователя - через аргумент `emails`.

Возможные значения аргумента:
* [`getdefault`](#emails-getdefault) - получить адрес по-умолчанию
* [`getyandex`](#emails-getyandex) - получить список нативных адресов
* [`getall`](#emails-getall) - получить список всех адресов
* [`testone`](#emails-testone) - проверить емейл на принадлежность пользователю

### emails=getdefault {#emails-getdefault}

Получить адрес для связи с пользователем.
Если у пользователя есть хотя бы один нативный или провалидированный внешний адрес, он будет выдан в ответе.
Для лайт-аккаунта будет выдан его адрес, указанный при регистрации.
Если у пользователя есть нативные e-mail адреса, будет выбран один из них, в зависимости от страны пользователя.
В противном случае будет выдан один из провалидированных (подтвержденных) внешних адресов, если такие имеются.

Пример ответа:
```xml
<address-list>
    <address validated="1" default="1" rpop="0" silent="0" unsafe="0" native="1" born-date="2011-01-14 12:59:58">test-user@yandex.com</address>
</address-list>`
```
```json
 "address-list" : [
    {
       "native" : true,
       "address" : "test-user@yandex.com",
       "silent" : false,
       "rpop" : false,
       "validated" : true,
       "default" : true,
       "unsafe" : false,
       "born-date" : "2011-01-14 12:59:58"
    }
 ]
```

### emails=getyandex {#emails-getyandex}

Получить только [нативные](#native) адреса пользователя, т.е. адреса почтового ящика этого же аккаунта.
Нативных адресов может не быть, если у пользователя нет почтового ящика на Яндексе или почтовый ящик заморожен.
Список адресов зависит от страны пользователя, в разных странах видны разные почтовые домены.
В ответе возвращаются только адреса с флагом `native`. Пример ответа можно посмотреть ниже.

### emails=getall {#emails-getall}

Получить все адреса пользователя, как [нативные](#native), так и [внешние](#external).

Фрагмент ответа в XML:
```xml
<address-list>
    <address validated="1" default="1" rpop="0" silent="0" unsafe="0" native="1" born-date="2011-01-14 12:59:58">test-user@yandex.com</address>
    <address validated="1" default="0" rpop="0" silent="0" unsafe="0" native="1" born-date="2011-01-14 12:59:58">test-user@yandex.com.tr</address>
    <address validated="0" default="0" rpop="0" silent="0" unsafe="1" native="0" born-date="2016-04-14 12:39:49">external-email@gmail.com</address>
</address-list>`
```
Фрагмент ответа в json:
```json
 "address-list" : [
    {
       "native" : true,
       "address" : "test-user@yandex.com",
       "silent" : false,
       "rpop" : false,
       "validated" : true,
       "default" : true,
       "unsafe" : false,
       "born-date" : "2011-01-14 12:59:58"
    },
    {
       "native" : true,
       "address" : "test-user@yandex.com.tr",
       "rpop" : false,
       "silent" : false,
       "unsafe" : false,
       "born-date" : "2011-01-14 12:59:58",
       "default" : false,
       "validated" : true
    },
    {
       "native" : false,
       "address" : "external-email@gmail.com",
       "rpop" : false,
       "silent" : false,
       "default" : false,
       "validated" : false,
       "born-date" : "2016-04-14 12:39:49",
       "unsafe" : true
    }
 ]
```

### emails=testone {#emails-testone}

Проверить, принадлежит ли конкретный e-mail адрес данному аккаунту.
Адрес передается в аргументе `addrtotest`, в режиме `emails=testone` аргумент `addrtotest` обязателен.

Т.к. отображаемый список [нативных](#native) адресов зависит от страны пользователя, то проверять привязку адреса поиском по ответу в режиме `emails=getall` нельзя, адрес может принадлежать аккаунту, но быть не виден в его стране.
Вместо этого нужно использовать режим `emails=testone`, который проверяет адрес по всем почтовым доменам Яндекса, а также по списку привязанных внешних адресов.

Если указанного адреса в списке e-mail-ов пользователя нет, в ответе будет пустой address-list, иначе в нем будет указанный адрес и его свойства.

## Аргумент getemails {#getemails}

Для чтения сырых данных непосредственно из расширенных атрибутов пользователя используется пара аргументов `getemails` и `email_attributes`.

Аргумент `getemails` определяет, какие адреса нужно выбрать. На данный момент поддерживается только значение `all` (все адреса).

Аргумент `email_attributes` определяет, какие атрибуты адреса нужно выбрать. Поддерживаемые значения - `all` (все атрибуты адреса) или список номеров атрибутов через запятую.
Если аргумент не передан или список пустой, то в ответе будет только список идентификаторов адресов, без атрибутов адреса.
Полный список атрибутов e-mail-ов приведен [в таблице атрибутов e-mail-ов](https://docs.yandex-team.ru/authdevguide/concepts/DB_About#section_gyv_v5f_2hb)

Пример: в запрос добавляются параметры `getemails=all&email_attributes=all`.
В ответе Черного ящика при этом появляется секция `emails`.
В XML:
```xml
<emails>
    <email id="2">
        <attribute type="1">my_email@gmail.com</attribute>
        <attribute type="2">1411571146</attribute>
        <attribute type="4">1411916746</attribute>
        <attribute type="6">1</attribute>
    </email>
    <email id="3">
        <attribute type="1">rpop.test@mail.ru</attribute>
        <attribute type="2">1412442345</attribute>
        <attribute type="5">1</attribute>
    </email>
</emails>
```
В json:
```json
"emails" : [
        {
           "id" : "2",
           "attributes" : {
              "6" : "1",
              "4" : "1411916746",
              "1" : "my_email@gmail.com",
              "2" : "1411571146"
           }
        },
        {
           "id" : "3",
           "attributes" : {
              "1" : "rpop.test@mail.ru",
              "2" : "1412442345",
              "5" : "1"
           }
        }
     ]

```
