# Программный интерфейс

Черный ящик позволяет проверять авторизационные данные пользователей Яндекса и получать информацию из базы данных Паспорта.
Эти возможности предоставляются сервисам Яндекса посредством API Черного ящика. Черный ящик представляет собой читающий интерфейс к базе данных Яндекс.Паспорта, для модификации данных нужно использовать [API Паспорта](https://doc.yandex-team.ru/Passport/passport-modes/).

API Черного ящика использует протокол HTTP(s). Вызовы методов API производятся с помощью методов GET или POST. Конфиденциальные параметры запроса (пароли, куки или токены) рекомендуется передавать в теле POST-запроса.

Каждый запрос к API должен включать параметр `method`, в значении которого указывается имя вызываемого метода. Имя метода определяет способ обработки данных запроса и формат ответа ЧЯ.

В таблице перечислены основные методы API Черного ящика, доступные сервисам.

Имя метода | Назначение метода
----- | -----
[login](../methods/login.md) | Аутентифицирует пользователя по паре логин/пароль.<br/><br/>При успешной аутентификации также может возвращать информацию о пользователе из базы данных Паспорта (см. раздел [Часто используемые данные системы авторизации](https://docs.yandex-team.ru/authdevguide/concepts/DB_About) документа [Подключение к системе авторизации](https://docs.yandex-team.ru/authdevguide)).<br/><br/> Метод `login` предназначен только для сервисов без веб-интерфейса. Сервисы с веб-интерфейсом проверяют пары логин/пароль с помощью режима Паспорта [`auth`](https://doc.yandex-team.ru/Passport/passport-modes/reference/auth.html) (описан в документе [Режимы паспорта](https://doc.yandex-team.ru/Passport/passport-modes/concepts/about.html)).
[sessionid](../methods/sessionid.md) | Аутентифицирует пользователя по значению куки `Session_id` (см. раздел [Куки системы авторизации](https://docs.yandex-team.ru/authdevguide/concepts/Auth_About) документа [Подключение к системе авторизации](https://docs.yandex-team.ru/authdevguide)).<br/><br/>При успешной аутентификации также возвращает информацию об аккаунте из базы данных Паспорта.
[oauth](../methods/oauth.md) | Проверяет OAuth-токен, выданный Яндекс.OAuth. Подробнее о реализации OAuth в Яндексе см. [Руководство разработчика OAuth](https://doc.yandex-team.ru/oauth/dg-internal/concepts/about.xml).<br/><br/>Для валидного OAuth-токена также может возвращать информацию о пользователе из базы данных Паспорта.
[userinfo](../methods/userinfo.md) | Возвращает информацию о пользователе из базы данных Паспорта.<br/><br/>Пользователь может быть идентифицирован:<br/>- уникальным номером в Паспорте (UID);<br/>- логином в Паспорте;<br/>- публичным идентификатором пользователя [public_id](ugc.md#public-id).
[user_ticket](../methods/user_ticket.md) | Возвращает информацию о пользователе из базы данных Паспорта. Ответы на запрос аналогичны ответам метода [userinfo](../methods/userinfo.md).<br/><br/>Пользователь идентифицируется по User-тикету TVM.
[lcookie](../methods/lcookie.md) | Расшифровывает куку L, извлекая UID и логин пользователя, а также время выставления куки.
[checkip](../methods/checkip.md) | Проверяет, принадлежит ли IP-адрес пользователя сетям Яндекса.

Как правило, даже если на стороне Черного Ящика произошла ошибка, ответ содержит HTTP-код 200, а описание ошибки содержится в теле ответа. Список подобных ошибок приведен в разделе [Ошибки обращения к Черному ящику](blackboxErrors.md).

Формат тела ответа по умолчанию — XML. Чтобы получить ответ в формате JSON, следует включить в запрос параметр format со значением «json».

## Способы передачи параметров запроса {#requests}

Параметры вызова Черного ящика можно передавать как в адресе GET-запроса так и в теле POST-запроса. Конфиденциальные параметры запроса (пароли, куки или токены) рекомендуется передавать в теле POST-запроса.
{% note warning %}

Значения всех параметров обязательно должны быть URL-encoded.

{% endnote %}


В адресе запроса параметры задаются традиционным для HTTP образом. Например, так выглядит первая строка запроса метода `userinfo` для пользователя с логином «zt.test» и IP-адресом 12.12.12.12:

```no-highlight
GET /blackbox?method=userinfo&login=zt.test&userip=12.12.12.12
```

В теле POST-запроса параметры можно оформить двумя способами. Ниже приведены примеры для каждого из них со следующими параметрами: метод — `login`, логин — «zt.test», пароль — «123», IP-адрес — «12.12.12.12». Незначимые заголовки опущены.

- Первый способ — закодировать строку параметров в формате URL-encoded, указав заголовок `Content-Type: application/x-www-form-urlencoded`.

    Пример:

    ```no-highlight
    POST /blackbox?method=userinfo HTTP/1.1
    Host: pass-test.yandex.ru
    Content-Length: 34
    Content-Type: application/x-www-form-urlencoded

    login=zt%2Etest&password=123&userip=12.12.12.12
    ```

- Поместить значение каждого параметра в отдельную часть тела запроса, указав заголовок `Content-Type: multipart/form-data`.

    Пример:

    ```no-highlight
    POST /blackbox?method=userinfo HTTP/1.1
    Host: pass-test.yandex.ru
    Content-Type: multipart/form-data;
    boundary=----------------------------bce4cdae7582
    Content-Length: 348

    ------------------------------bce4cdae7582
    Content-Disposition: form-data; name="login"

    zt.test
    ------------------------------bce4cdae7582
    Content-Disposition: form-data; name="password"

    123
    ------------------------------bce4cdae7582
    Content-Disposition: form-data; name="userip"

    12.12.12.12
    ------------------------------bce4cdae7582--
    ```


