# Виды Черных ящиков

Паспорт поддерживает несколько окружений Черного ящика.

Номера TVM-приложений можно найти [здесь](getting-access.md#okruzheniya).

## Боевой ЧЯ {#section_production}

Используется боевыми серверами сервисов. Доступен по адресу `https://blackbox.yandex.net/blackbox`.
Выдает информацию о пользователях портала Яндекс и корректно обрабатывает только те куки и токены, которые были выписаны боевым Паспортом.

## Мимино {#section_mimino}

Используется для отладки работы сервисов с реальными данными пользователей, в частности, провязок между сервисами. Доступен по адресу `https://blackbox-mimino.yandex.net/blackbox`.

Мимино работает со специальной версией паспортной базы, в которой все персональные сведения о пользователях (ФИО, пол, адреса и телефоны) вымышленные. Все остальные данные — логины, пароли, токены, UID — являются настоящими. Мимино корректно обрабатывает только куки и токены, выставленные боевым Паспортом.

{% note warning %}

Мимино не предназначен для стресс-тестирования. Нагрузочное тестирование, в ходе которого необходимо использовать Мимино с интенсивностью, превышающей несколько десятков запросов в секунду, следует согласовать с администраторами Паспорта (рассылка [passport-admin@](mailto:passport-admin@yandex-team.ru)).
Также, Мимино не предназначен для использования в боевом контуре. Стабильность работы и времена ответов могут отличаться от боевого Черного ящика.

{% endnote %}


## Тестовый ЧЯ {#section_testing}

Используется для разработки и функционального тестирования сервисов. Доступен по адресу `https://blackbox-test.yandex.net/blackbox`.

Тестовый Черный ящик работает с тестовой паспортной базой, которая хранит учетные записи [тестового Паспорта](https://passport-test.yandex.ru).
Логины и `UID`-ы пользователей тестового Паспорта могут пересекаться с данными из боевой базы, но это не более чем совпадение, это разные базы пользователей.
Кука `Session_id`, выписанная тестовым Паспортом, не принимается боевым Черным ящиком и Мимино. И наоборот, кука, выставленная боевым Паспортом, не принимается тестовым Черным ящиком.

## Внутренний ЧЯ (yandex-team.ru) {#section_internal}

Используется внутренними сервисами Яндекса. Доступен по адресу `https://blackbox.yandex-team.ru/blackbox`.

Внутренний ЧЯ работает с базой корпоративного Паспорта, которую наполняют сотрудники Яндекса с помощью корпоративной ActiveDirectory (AD).
Персональные данные сотрудников в базе отсутствуют, ФИО, телефоны и аватарки сотрудников хранятся на Стаффе.

Особенности внутреннего Черного ящика описаны в вики: [https://wiki.yandex-team.ru/passport/corporate](https://wiki.yandex-team.ru/passport/corporate).

## Стрессовые реплики ЧЯ {#section_stress}

Используются для нагрузочного тестирования. Все стрессовые ЧЯ объединены в файрволльную группу [`_SEZAMSTRESSSRV_`](https://racktables.yandex.net/export/expand-fw-macro.php?macro=_SEZAMSTRESSSRV_) и распределены по дата-центрам:

- Ивантеевка: pass-stress-i1.sezam.yandex.net
- Мытищи: pass-stress-m1.sezam.yandex.net
- Сасово: pass-stress-s1.sezam.yandex.net

Также все стрессовые реплики объединены в ферму `blackbox-stress.yandex.net:http,https`. Ферма позволяет всегда получать ответ от ближайшей доступной реплики ЧЯ и не зависеть от технических работ на стороне Паспорта. Ферма имеет ограничение нагрузки в 50K RPS. Если ваш сервис генерирует большую нагрузку в ЧЯ, рекомендуется использовать отдельные стрессовые реплики.

Стрессовые ЧЯ работают с данными боевой базы, в которой все персональные сведения о пользователях вымышленные, а неперсональные сведения – реальные.
Большие наборы кук для нагрузочного тестирования можно заказывать на [passport-dev@](mailto:passport-dev@yandex-team.ru).

При ошибках стрессовые реплики возвращают HTTP-код 500 (боевой Черный ящик всегда возвращает ответы с кодом 200).

#### Куки для отправки запросов к стрессовым репликам

Чтобы отправлять запросы к стрессовому ЧЯ, используйте специально сгенерированные стрессовые куки `Session_id`. Сгенерировать куки можно двумя способами:

#### При помощи сборки Jenkins
Чтобы сгенерировать куки:
1. Создайте текстовый файл `uids.txt` и перечислите все идентификаторы пользователей, для которых необходимо сгенерировать куки. Каждый новый uid перечисляйте с новой строки.
1. Зайдите на страницу [задачи в Jenkins](https://jenkins-load.yandex-team.ru/job/sessionid_generator2/), нажмите кнопку **Build with Parameters**, загрузите созданный файл и нажмите кнопку **Собрать**.
1. Когда задача будет выполнена, заберите из сборочной директории файл `output.txt` с куками.

#### При помощи задачи в Sandbox

Чтобы сгенерировать куки:

1. Перейдите в [Sandbox](https://sandbox.yandex-team.ru/), нажмите кнопку **Create** и выберите тип задачи `GENERATE_STRESS_SESSION_IDS`.
1. В блоке **Task custom parameters** в поле **List of uids, separated by newline** перечислите идентификаторы пользователей, для которых необходимо сгенерировать куки. Каждый новый uid перечисляйте с новой строки.
1. Нажмите кнопку **Run**.
1. Когда задача будет выполнена, список сгенерированных кук будет доступен на вкладке **RESOURCES**.
