# О чём речь?

Это возможность обезопасить данные пользователя на отдельных сервисах.

{% note warning %}

Технология работает пока только в yandex-team окружении.
В большом проде (`yandex.<TLD>`) пока запущена только в dry-run режиме.

{% endnote %}

## Какие проблемы решаем?
1. Любой сервис может проксировать запросы во фронтенд любого сервиса. Кто-то может воспользоваться чужими полномочиями.
2. Сервисы логируют куки целиком. Злоумышленник может воспользоваться залогированной кукой `Session_id`.
3. Сервисы отражают куки в ответах на CORS запросы. Злоумышленник может воспользоваться кукой `Session_id` из ответа.

## Как решаем эти проблемы?
Считаем, что корень проблемы в том, что на портале для аутентификации запросов используется одна-единственная кука `Session_id`, устанавливаемая на домене второго уровня `yandex[-team].<TLD>`.
Поэтому заводим на доменах третьего уровня `service.yandex[-team].<TLD>` дополнительную куку - `sessguard`. Кука `sessguard` от одного сервиса не подходит для другого.

# Подключение фичи

## Подготовка

1. Выписать доменные имена третьего уровня, на которых расположены ручки - их мы будем защищать от перечисленных выше проблем.

    Будем считать, что таких домена два, и они называются `service` и `service-test`.

2. Выписать все различные data flow, в которых запрос с куками отправляется с юзер-агента (браузера, например) на url под защищаемыми доменами, и в конечном итоге достигает `/blackbox?method=sessionid`. Например:
    * переход по гиперссылке на адрес `helper.service.yandex[-team].<TLD>`;
    * xhr в ручку `api.service.yandex[-team].<TLD>/helper`.

  Вам предстоит понять, как во всех этих случаях юзер-агент получит от веб-сервера (часто это nodejs) указание на то, что в его запросе не было куки `sessguard`, и выполнит [редирект](#obnovlenie-sessguard).

## Внедрение в dry-run

1. Найти и поправить все места в сервисе, где используется `/blackbox?method=sessionid`: в параметре [host](../methods/sessionid.md#host) имя хоста из заголовка `Host` должно передаваться без изменений.
    * Фронтенд должен будет передавать в ЧЯ `host=service.yandex[-team].<TLD>` или `host=subservice.service.yandex[-team].<TLD>`, но никак не `host=yandex[-team].<TLD>`, иначе blackbox не осознает, что при проверке нужна вторая кука.
    * Бекенд, который получает от фронтенда куки, должен будет делать то же самое. Хотя правильнее, конечно, использовать аутентификацию с TVM service+user ticket'ами.
    * Некоторые бекенды аутентифицируют запросы от других бекендов при помощи куки `Session_id`. Или аутентифицируются в других бекендах при помощи куки `Session_id`. Все такие случаи надо перевести на TVM либо отдельно обсудить с командой Паспорта. Очень хочется, чтобы читатель понимал: если какой-то бекенд на другом конце Яндекса принесёт в `/blackbox?method=sessionid` одну куку и передаст в параметре host домен третьего уровня, для которого включено требование второй куки, ЧЯ отклонит такой запрос.
    * Косвенно `/blackbox?method=sessionid` используется, когда бекенд или мобильное приложение использует ручку `/token?grant_type=sessionid`. Использование этой ручки с бекенда надо отдельно обсудить с командой Паспорта. Про мобильные приложения ниже есть [раздел](#v-mobilnyh-prilozheniyah).

2. Добавить в запрос к blackbox параметр [sessguard](../methods/sessionid.md#sessguard).

    Т.е. передаётся параметр `sessguard=`: вне зависимости от того, была кука в запросе или нет - так проще искать сценарии, где sessguard забыли передать.

3. Поддержать `status=WRONG_GUARD` в ответе `/blackbox?method=sessionid`. Этот [статус](../methods/sessionid.md#status) указывает на то, что в пользовательском запросе не было обязательной куки `sessguard` (или сервис забыл передать её). В этом случае надо [обновить куку](#obnovlenie-sessguard).

### Обновление sessguard
Юзер-агента надо отредиректить на адрес:

`https://passport.yandex[-team].<TLD>/auth/guard`

Домен второго уровня в имени хоста сервиса (это то, что юзер-агент передал в заголовке запроса `Host`) и имени хоста Паспорта должны совпадать. В параметре `retpath` надо передать адрес, на который Паспорт вернёт юзер-агента после выполнения всех нужных действий.

Поддержка `status=WRONG_GUARD` чем-то напоминает поддержку `status=NEED_RESET`. Статус `NEED_RESET` указывает на то, что авторизационные куки в целом ничего, но лучше бы их подновить; для этого юзер-агент должен сделать запрос в ручку `https://passport.yandex[-team].<TLD>/auth/update`. Статус `WRONG_GUARD` отличает то, что запрос нельзя считать авторизованным.

Мы в Паспорте всячески отговариваем вас самостоятельно делать запросы в ручки `/auth/guard` и `/auth/update`. Это ещё опаснее и больнее, чем лизать раскалённую сковородку.

## Полноценное включение фичи

Происходит с участием команды Паспорта: на стороне blackbox по логам можно найти множество проблем. Команда Паспорта будет репортить о них, а команда сервиса будет их чинить.

Опциональный этап перед полноценным включением - обогатить пользователей сервиса этой кукой, чтобы было проще найти сценарии, где куку забыли передать.
Эта фича может выкатываться на процент userip.
В этом случае если нет валидной куки, то blackbox возвращает статус `NEED_RESET`.

Включение строгой валидации sessguard может происходить плавно - на процент userip. Обычно так и делаем.
В этом случае если нет валидной куки, то blackbox возвращает статус `WRONG_GUARD`.

## В мобильных приложениях

### Android
Со стороны приложения необходимо выполнить следующее:
В местах использования метода `PassportApi.authorizeByCookie(PassportCookie)` поменять метод создания объекта `PassportCookie`.

Было:
```kotlin
val passportCookie = PassportCookie.from(environment, sessionId, returnUrl)
```
Стало:
```kotlin
val allCookies = CookieManager.getInstance().getCookie(url)
val passportCookie = PassportCookie.fromAllCookies(environment, allCookies, returnUrl)
```

### iOS
В местах где приложение использовало метод `YALAuthenticator authenticateWithParameters:...` с параметром `kYALAuthenticatorGrantTypeKey = YALGrantTypeSessionID` необходимо изменить параметр `kYALAuthenticatorGrantTypeKey` на `YALGrantTypeSessionCookies` и удалить параметр `kYALAuthenticatorSessionIDKey`.
Было:
```swift
authenticator.authenticate(withParameters:[
  kYALAuthenticatorGrantTypeKey: YALGrantType.sessionID.rawValue as NSNumber,
  kYALAuthenticatorSessionIDKey: sessionId,
  kYALAuthenticatorHostKey: host
]) {...}
```
Стало:
```swift
authenticator.authenticate(withParameters:[
  kYALAuthenticatorGrantTypeKey: YALGrantType.sessionCookies.rawValue as NSNumber,
  kYALAuthenticatorHostKey: host
]) {...}
```
