# Указание автора пользовательского контента

В сервисах, которые позволяют пользователям создавать контент, может понадобиться указать, кто является автором статьи, отзыва или плейлиста. Публично связывать UGC (user-generated content) с UID или логинами пользователей запрещено, поэтому Паспорт поддерживает [_публичные идентификаторы_](#public-id) и [_публичные имена_](#public-name) пользователей.

#### Публичный идентификатор пользователя (public_id) {#public-id}

Позволяет идентифицировать весь контент, принадлежащий определенному пользователю на каждом сервисе, не используя напрямую логин или UID. Например:

- Маркет: `https://market.yandex.ru/user/kbatnddm0yq/reviews`

- Дзен: `https://zen.yandex.ru/user/kbatnddm0yq`

- Отзывы: `https://yandex.ru/user/kbatnddm0yq`


По-умолчанию публичный идентификатор генерируется на основе UID, но может быть изменен пользователем, поэтому стоит использовать его только для URL профилей. Публичный идентификатор уникален, поэтому с его помощью также можно получить сведения о пользователе с помощью метода [userinfo](../methods/userinfo.md).

[Подробнее об использовании public_id](#public-id-use).

#### Публичное имя пользователя (public_name) {#public-name}

Позволяет указывать автора для каждой конкретной единицы контента, не используя реальное имя пользователя (подписывать публичный плейлист на Музыке или отзыв на Маркете).

В публичном имени пользователи могут использовать любые символы, поэтому полученную строку следует экранировать перед обработкой.

{% note info %}

Внутри сервиса идентифицировать аккаунты следует только с помощью UID: если вам зачем-то нужно хранить `public_name` или `public_id` в своей базе данных, договоритесь об этом с Паспортом.

{% endnote %}



## Как запросить нужное поле {#request}

Методы Черного ящика [userinfo](../methods/userinfo.md), [login](../methods/login.md), [oauth](../methods/oauth.md), [user_ticket](../methods/user_ticket.md) и [sessionid](../methods/sessionid.md) поддерживают параметры для запроса публичного имени и публичного идентификатора пользователя:

- Чтобы запросить публичное имя, передайте параметры `regname=yes` и `get_public_name=yes`.

    Черный ящик вернет элемент `public_name` в составе структуры `display_name`.

    #### Пример

    ```
    "display_name":
    {
        "name": "barsik1",
        "public_name": "Барсик Б.",
        "verified": true,
        "avatar":
        {
            "default": "1450/4001517835-40324",
            "empty": false
        }
    }
    ```

    ❗️ **Для получения публичного имени необходим грант `allow_get_public_name`.**

- Чтобы запросить публичный идентификатор, передайте параметр `get_public_id=yes`. Черный ящик вернет строковый элемент `public_id`.
  Для получения публичного идентификатора грант не требуется.


## Использование public_id {#public-id-use}

Публичный идентификатор пользователя задается Паспортом:

- Идентификатор может содержать заглавные и строчные английские буквы, цифры, дефисы <q>-</q>, и точки <q>.</q>.
- `public_id` может измениться, поэтому не стоит широко использовать его в ссылках, которые подразумеваются постоянными.
- `public_id` можно использовать, чтобы запросить информацию о пользователе в Черном ящике, но он менее надежен, чем UID (теоретически один и тот же `public_id` может в разное время соответствовать разным аккаунтам).

{% note info %}

Публичный идентификатор пользователя **не стоит** использовать в ссылках на сам контент (например, плейлисты или посты), так как этот идентификатор может измениться. Для отдельных единиц контента надежнее генерировать специальные идентификаторы на стороне сервиса (не `service.yandex.ru/user-3661/1`, а `service.yandex.ru/content/123456`).

{% endnote %}


Не следует предоставлять доступ из интернета к ручкам, которые могут стать инструментом скрэпперов, например:

- Неконтронтролируемо получать списки существующих `public_id`.
- Получать `public_id` в обмен на логин или UID (например, нельзя делать редиректы с URL, параметризованного логином, на URL, параметризованный `public_id`).

Необходимость и реализацию таких ручек нужно согласовывать с СИБ.


## Использование public_name {#public-name}

Пользователь может задать свое публичное имя в своем профиле в Паспорте:

- В публичном имени могут использоваться любые символы.
- Длина публичного имени может достигать сотен символов.
- Значение поля `public_name`, полученное из Черного ящика, нужно экранировать (с помощью `encode` или `stringify`), чтобы обезопаситься от исполняемого кода, который пользователь может ввести в качестве имени.

## Признак верифицированности {#verified}

Пользователь может быть верфицирован: об этом расскажет поле [verified](../methods/userinfo.md#display_name-greaterverified).
Если поля нет, то пользователь не верифицирован. Т.е. либо оно есть и имеет значение `true|1`, либо отсутствует.
