# О справочнике

Черный ящик (ЧЯ, blackbox) — это внутренний HTTP-сервис, являющийся частью системы авторизации Яндекса. Основная задача Черного ящика — проверка авторизационных данных пользователей публичных сервисов Яндекса. Также ЧЯ предоставляет возможность получать информацию из базы данных Паспорта.

Настоящий документ содержит описание программного интерфейса Черного ящика и процедуры получения доступа к ЧЯ. Самые последние изменения в API разработчики описывают в Вики: https://wiki.yandex-team.ru/passport/blackbox.

Целевой аудиторией документа являются разработчики, которые используют авторизацию пользователей на сервисах или нуждаются в информации об учетных записях из базы данных Паспорта.

## Структура документа

Документ включает следующие разделы:
Общие сведения: [краткое описание Черного ящика](concepts/overview.md), [описание процедуры получения доступа к Черному ящику](concepts/getting-access.md).
Программный интерфейс: [описание HTTP-интерфейсa Черного ящика и доступных методов API](concepts/intro-api.md).

## Соглашения
В документе приняты следующие соглашения:

* О терминологии. При описании API Черного ящика используются понятия системы авторизации [Яндекс.Паспорта](https://passport.yandex.ru), рассмотренные в документе [Яндекс.Паспорт. Обзор системы авторизации](https://docs.yandex-team.ru/authdevguide/) (далее «Подключение к системе авторизации»). Предполагается, что пользователь API знаком с этими понятиями и общей схемой аутентификации.
* О формате URL. Во всех примерах данного документа URL приведены в удобном для чтения виде. В реальных запросах URL должны передаваться в формате URL-encoded.

В примере справочника:
```
https://blackbox.yandex.net/blackbox/?
method=sessionid
& host=beta.yandex.ua
& sessionid=1172140426.135.2.100001.2:565024:5.yandex.ua:1279.383.cf9a4a2a802bc31fc2ea69613a78a48e
& userip=192.168.1.1
```
В URL-encoded виде:

```
https://blackbox.yandex.net/blackbox/?method=sessionid&host=beta%2Eyandex%2Eua /
&sessionid=1172140426%2E135%2E2%2E100001%2E2%3A565024%3A5%2Eyandex%5Fua%3A1279%2E383%2Ecf9a4a2a802bc31fc2ea69613a78a48e&userip=192%2E168%2E1%2E1
```
Во всех приведенных примерах используется адрес боевого Черного ящика.
