# Метод sendsms (отправка сообщения)

Метод предназначен для отправки сообщения указанному пользователю или на указанный номер телефона. Если в запросе указан не номер телефона, а UID, то пользователь получит сообщение на номер по умолчанию для аккаунта с этим UID (помеченный атрибутом 107 в ответе метода [userinfo](https://docs.yandex-team.ru/blackbox/methods/userinfo), который был вызван с параметром `getphones=bound`).

Если нужно отправить SMS пользователю Яндекса, правильно указывать именно идентификатор пользователя (параметр `uid`), а не конкретный номер телефона. Если пользователь привязал какой-либо номер к аккаунту, Паспорт автоматически выберет его для отправки сообщения.

{% note warning %}

Не предоставляйте пользователям возможность отправки произвольного текста на произвольные номера телефонов. Этим вы откроете пространство для мошенников.

{% endnote %}

## Формат запроса {#request}

```text
https://sms.passport.yandex.ru/sendsms
  ? (sender=<идентификатор сервиса-отправителя> & text=<текст SMS>)
  & ([uid=<UID получателя>] | [phone=<номер телефона>])
  & [phone_id=<идентификатор номера телефона>]
  & [route=<имя маршрута>]
  & [udh=<User Data Header>]
  & [identity=<идентификатор сообщения>]
  & [device_id=<идентификатор устройства>]
  & [request_path=<ручка, из которой отправляется SMS>]
  & [scenario=<описание сценария>]
  & [allow_unused_text_params=<yes/true/1>]

## Тело запроса
[text_template_params=<параметры шаблона>]

```

### Заголовки

  * X-Ya-Service-Ticket

    [Service-тикет TVM](https://wiki.yandex-team.ru/passport/tvm2/stbrief).
    Заголовок используется для авторизации вашего сервиса.

  * Ya-Consumer-Client-Ip

    IP-адрес пользователя, для которого отправляется sms.
    Заголовок используется для антифрода.
    Надо передавать только в случаях, когда они есть: обычно это интерактивные сценарии (например, подтвердить действие пользователя).

  * Ya-Client-User-Agent

    UserAgent из браузера пользователя. as-is.
    Заголовок используется для антифрода.
    Надо передавать только в случаях, когда они есть: обычно это интерактивные сценарии (например, подтвердить действие пользователя).

### Параметры

Параметр | Описание
----- | -----
`sender*` | Идентификатор сервиса, отправляющего запрос. Присваивается при регистрации сервиса в YaSMS. <br> От значения параметра зависят гранты на использование методов YaSMS и их параметров. <br> Если указанное значение не зарегистрировано командой Паспорта, YaSMS возвращает ошибку с кодом `DONTKNOWYOU`.|
`text*` | Если `text_template_params`: <br> <ul><li>**Отсутствует**: текст сообщения в кодировке UTF-8.</li><li>**Присутствует**: шаблон текста в кодировке UTF-8.<ul><li>шаблонизатор заменяет все подстроки вида `{{ param_name }}` на значение `param_name` из `text_template_params`</li><li>ключи могут содержать только alphanumeric и underscore символы(\\w)</li><li>одиночные символы `{` и `}` - легальны, не требуют экранизации и могут использоваться свободно</li><li>двойные фигурные скобки (`{{` и `}}`) - специальные значения и их никак нельзя использовать ни в значениях параметров, ни в шаблоне (вне определения параметров). экранизация не предусмотрена</li><li>наборы параметров должны строго быть идентичны между словарем и шаблоном. Это требование можно ослабить, см. параметр `allow_unused_text_params`</li><li>любое несоблюдение этих правил ведет к `INVALIDTEMPLATEORPARAMS`</li></ul></li></ul> |
`uid`| UID пользователя. Сообщение отправляется на номер по умолчанию для соответствующего аккаунта. <br> Чтобы отсылать сообщения определенным аккаунтам Яндекса, необходимо получить грант SmsFromUid с помощью [формы](https://forms.yandex-team.ru/surveys/17153/). <br> Параметр обязателен, если не указан параметр phone.|
`phone`| Телефонный номер должен быть указан в международном формате +<код><номер>, в кодировке URLEncoded, например `%2B71234567890`. <br> Чтобы отсылать сообщения на анонимные номера, необходимо получить грант AnonymSms с помощью [формы](https://forms.yandex-team.ru/surveys/17153/). <br> На каждый анонимный номер можно отправить не больше 20 сообщений в день. <br> Параметр обязателен, если не указан параметр uid.|
`phone_id`| Идентификатор номера телефона пользователя, чей UID указан в значении параметра uid. Если phone_id не указан, сообщение отправляется на номер по умолчанию. <br> Чтобы узнать идентификатор нужного номера, или понять, есть ли у пользователя номер по умолчанию, вызовите метод Черного ящика [userinfo](https://docs.yandex-team.ru/blackbox/methods/userinfo) с параметром `getphones=bound` и проанализируйте массив phones в ответе. Идентификатор каждого номера указан в свойстве id для элемента массива, а для номера по умолчанию проставлен атрибут "107": "1". <br> Если указанный номер не подтвержден данным пользователем, YaSMS возвращает ошибку с кодом `NOCURRENT`.|
`route`| Маршрут, по которому нужно послать сообщение. <br> По умолчанию используется маршрут «default». <br> Чтобы использовать маршрут отличный от default, необходимо получить грант Routes (для этого укажите нужный маршрут при запросе грантов с помощью [формы](https://forms.yandex-team.ru/surveys/17153/). <br> О том, как правильно выбрать маршрут, можно проконсультироваться с командой Паспорта (passport-dev@yandex-team.ru).|
`udh`| Заголовок, декларирующий формат и метод обработки SMS. Википедия: [User Data Header](https://en.wikipedia.org/wiki/User_Data_Header). <br> YaSMS использует шлюз Kannel, подробности о UDH правильно искать в его [документации](https://kannel.org/userguide.shtml).|
`identity`| Произвольный идентификатор сообщения, который логируется для успешно отправленных сообщений. Комбинируя их с идентификаторами сообщений, которые генерирует YaSMS, вы можете классифицировать сообщения в общем потоке.|
`text_template_params`| Json типа `string`->`string`. Если он присутствует, то параметр `text` становится шаблоном. Его использование разрешено только только в теле POST-запроса. Использование `text_template_params` вне тела запроса приведет к ошибке `USERDATANOTINBODY`|
`allow_unused_text_params`| Признак того, что среди параметров `text_template_params` могут быть неиспользуемые в шаблоне текста значения (по умолчанию, наличие таких параметров приводит к ошибке `INVALIDTEMPLATEORPARAMS`).|
`device_id`| Идентификатор устройства пользователя (обычно - для мобильных устройств). Параметр используется для антифрода. Надо передавать только в случаях, когда они есть: обычно это интерактивные сценарии (например, подтвердить действие пользователя). |
`request_path`| Ручка, из которой сервис инициирует отправку смс. Используется для антифрода. Не более 512 символов. |
`scenario`| Сценарий, в котором отправляется смс, в произвольной текстовой форме. Используется для антифрода. Не более 255 символов. |

`*` - Обязательный параметр

### Антифрод

Для всех sms перед отправкой проверяется вердикт антифрода. Для его качественной работы надо передавать:
  * заголовок `Ya-Consumer-Client-Ip`
  * заголовок `Ya-Client-User-Agent`
  * параметр `device_id`
  * параметр `request_path`
  * параметр `scenario`

{% note info %}

Запрос в антифрод выполняется асинхронно по техническим причинам: YaSMS отвечает за десятки миллисекунд, а антифрод - за сотни. Поэтому в ответе ручки `/sendsms` невозможно отобразить вердикт антифрода, т.к. его ещё нет.

{% endnote %}


## Формат ответа {#response}

Формат XML-ответа YaSMS зависит от результата обработки запроса. Разбирать ответ рекомендуется с помощью XML-парсера, а не регулярных выражений (их труднее поддерживать при изменениях формата).

## Сообщение успешно отправлено

В ответ возвращается XML с идентификатором отправленного сообщения:

```xml
<?xml version="1.0" encoding="windows-1251"?>
<doc>
    <message-sent id="127000000003456" />
    <gates ids="15" />
</doc>
```

Значение атрибута `id` — строка (**не число!**), уникальный идентификатор отправленного сообщения в YaSMS. Все сообщения, отправленные боевой версией сервиса, логируются в Статбоксе и раз в день выгружаются в [таблицы YT](https://yt.yandex-team.ru/hahn/navigation?path=//statbox/yasms-log&).

{% note info %}

Формат и содержание логов могут измениться — обращайтесь к команде Паспорта, если вас интересуют определенные данные об отправленных сообщениях.

{% endnote %}


## Произошла ошибка {#error}

В ответ возвращается XML с сообщением об ошибке:

```
<?xml version="1.0" encoding="windows-1251"?>
<doc>
    <error>User does not have an active phone to receive messages</error>
    <errorcode>NOCURRENT</errorcode>
</doc>
```

Поддерживаются следующие коды ошибок:

Код ошибки | Комментарий
----- | -----
`BADFROMUID` | Параметр from_uid может содержать только цифры.
`BADPHONE` | Телефонный номер задан в некорректном формате.
`DONTKNOWYOU` | Отправитель запроса не распознан (неизвестное значение параметра sender).
`INTERROR` | Внутренняя ошибка, запрос следует повторить.
`LIMITEXCEEDED` | Превышен дневной лимит отправки сообщений на телефонный номер.
`NOCURRENT` | Пользователь с заданным uid не найден или у него отсутствует основной номер телефона.
`NOPHONE` | Не указан номер телефона (параметр phone).
`NORIGHTS` | У отправителя недостаточно прав для отправки сообщений.
`NOROUTE` | Отсутствует маршрут доставки сообщений на указанный номер.
`NOSENDER` | Не указан сервис-отправитель (параметр sender).
`NOTEXT` | Не задан текст сообщения.
`NOUID` | Не указан UID пользователя, хотя подразумевается отправка сообщения определенному аккаунту (например, указан параметр mobileauth).
`PERMANENTBLOCK` | Номер перманентно заблокирован (занесен в черный список администраторами Паспорта).
`PHONEBLOCKED` | Номер перманентно заблокирован (занесен в черный список администраторами Паспорта).
`INVALIDTICKET` | Сервис тикет не валиден
`NOTICKET` | Сервис тикет не был предоставлен
`USERDATANOTINBODY` | Параметр `text_template_params` был отправлен вне тела запроса
`INVALIDTEMPLATEORPARAMS` | Шаблон (`text`) или параметры (`text_template_params`) не валидны
