package ru.yandex.passport.hbase.failsafe
 
import org.apache.commons.pool2.{BasePooledObjectFactory, PooledObject}
import org.apache.commons.pool2.impl.DefaultPooledObject
import org.apache.hadoop.conf.Configuration
import org.apache.hadoop.hbase.client.{HTable, HTableInterface}
 
class HTablePooledObjectFactory(configuration: Configuration,
                                tableName: String)
  extends BasePooledObjectFactory[HTableInterface]{
 
  @Override
  def create: HTableInterface = {
    new HTable(configuration, tableName)
  }
 
  @Override
  def wrap(value: HTableInterface): PooledObject[HTableInterface] = {
    new DefaultPooledObject[HTableInterface](value)
  }
 
  @Override
  override def destroyObject(p: PooledObject[HTableInterface]) {
    p.getObject.close()
  }
 
}
