package ru.yandex.passport.historydb.api.actions

import play.Logger
import play.api.libs.json.{JsArray, JsString, Json}
import play.api.mvc.Results._
import play.api.mvc._

import scala.concurrent.Future


object ErrorHandler extends
    ActionBuilder[Request] {

  implicit val ec = this.executionContext

  def invokeBlock[A](request: Request[A], block: (Request[A]) => Future[Result]) = {
    block(request) recover { case ex: Throwable =>
      Logger.error("Internal error", ex)
      InternalServerError(
        Json.obj(
          "status" -> JsString("error"),
          "errors" -> JsArray(List(
            Json.obj("code" -> "internal", "message" -> ex.toString)
          ))
        )
      )
    }
  }
}