package ru.yandex.passport.historydb.api.actions

import play.api.mvc.{ActionBuilder, ActionTransformer, Request}
import ru.yandex.passport.historydb.api.requests.ProtectedRequest

import scala.concurrent.Future

object ProtectedAction extends
    ActionBuilder[ProtectedRequest] with ActionTransformer[Request, ProtectedRequest] {

  val CONSUMER_FIELD = "consumer"

  def transform[A](request: Request[A]) = Future.successful {
    new ProtectedRequest(request.headers.get("x-ya-service-ticket"), request.getQueryString(CONSUMER_FIELD), request)
  }

}
