package ru.yandex.passport.historydb.api.actors

import akka.actor.Actor
import play.Logger
import ru.yandex.passport.historydb.api.util.GrantsHolder
import ru.yandex.passport.util.Grants

import scala.concurrent.duration._


case class ReloadGrants()


class GrantsReloaderActor(grantsConfig: String, reloadInterval: FiniteDuration) extends Actor {
  import context.dispatcher

  override def preStart() = scheduleReload()

  override def postRestart(reason: Throwable) = {}

  def scheduleReload() = context.system.scheduler.scheduleOnce(reloadInterval, self, ReloadGrants)

  def receive = {
    case ReloadGrants => {
      Logger.info("Start grants reloading...")
      try {
        GrantsHolder.setGrants(Grants.fromFile(grantsConfig))
        Logger.info("Grants reloaded")
      } catch {
        case ex: Throwable => {
          Logger.warn("Unable to reload grants", ex)
        }
      }
      scheduleReload()
    }
  }
}
