package ru.yandex.passport.historydb.api.actors

import ru.yandex.passport.historydb.api.util.ServiceContextHolder
import akka.actor.Actor
import play.Logger

import scala.concurrent.duration.FiniteDuration

case class ReloadKeys()


class KeysReloaderActor(reloadInterval: FiniteDuration) extends Actor {
  import context.dispatcher

  override def preStart() = scheduleReload()

  override def postRestart(reason: Throwable) = {}

  def scheduleReload() = context.system.scheduler.scheduleOnce(reloadInterval, self, ReloadKeys)

  def receive = {
    case ReloadKeys => {
      Logger.info("Start keys reloading...")
      try {
        ServiceContextHolder.resetKeys()
        Logger.info("Keys reloaded")
      } catch {
        case ex: Throwable => {
          Logger.warn("Unable to reload keys", ex)
        }
      }
      scheduleReload()
    }
  }
}
