package ru.yandex.passport.historydb.api.clients


import com.google.common.io.BaseEncoding
import play.api.Play.current
import play.api.libs.ws._

import scala.util.{Success, Try}


class BadBlackboxResponse(message: String) extends Exception(message)


class InvalidJson(message: String) extends BadBlackboxResponse(message)


class Blackbox private(val blackboxUrl: String, val blackboxTimeoutMs: Int) {
  val blackboxUrlWithPath = blackboxUrl + "/blackbox"

  val TEST_PWD_HASHES_METHOD = "test_pwd_hashes"

  def base64PasswordFromPasswordHashes(passwordHashes: Iterable[String]) = {
    passwordHashes.map(p => BaseEncoding.base64().encode(p.getBytes))
  }

  def test_pwd_hashes(uid: Long, password: String, passwordsHashes: List[String], format: String = "json") = {
    val base64Passwords = base64PasswordFromPasswordHashes(passwordsHashes)
    val complexHolder: WSRequestHolder = WS.url(blackboxUrlWithPath)
      .withHeaders("Accept" -> "application/json")
      .withRequestTimeout(blackboxTimeoutMs)
      .withQueryString("method" -> TEST_PWD_HASHES_METHOD, "format" -> format)
    complexHolder.post(
      Map("password" -> Seq(password), "hashes" -> Seq(base64Passwords.mkString(",")), "uid" -> Seq(uid.toString))
    )
  }

  def parse_test_pwd_hashes(response: WSResponse) = {
    Try(response.json) match {
      case Success(jsonBody) => {
        ((jsonBody \ "hashes").asOpt[Map[String, Boolean]]) match {
          case Some(hashes) => hashes.map {
            case (base64PasswordHash, matched) => new String(BaseEncoding.base64().decode(base64PasswordHash)) -> matched
          }.toMap
          case _ => throw new InvalidJson(f"Hashes not found or not valid: $jsonBody%s")
        }
      }
      case _ => {
        throw new InvalidJson("Bad json:" + response.body)
      }
    }
  }

}


object Blackbox {
  def apply(blackboxUrl: String, blackboxTimeoutMs: Int) = new Blackbox(blackboxUrl, blackboxTimeoutMs)
}
