package ru.yandex.passport.historydb.api.controllers

import play.api.Play.current
import play.api.data.Form
import play.api.libs.concurrent.Akka
import play.api.libs.concurrent.Execution.Implicits.defaultContext
import play.api.libs.json.{JsObject, JsValue, Json}
import play.api.mvc.Results._
import play.api.mvc.{Result, _}

import scala.concurrent.Future

trait HistorydbController  {

  val hbaseContext = Akka.system.dispatchers.lookup("historydb-dispatcher")


  def buildSuccessfulResponse[T](requestIdKey: String, requestIdValue: JsValue, itemsKey: String, response: JsValue, extra: JsObject = Json.obj()) = {
    val resp = Json.obj(
      "status" -> "ok",
      requestIdKey -> requestIdValue,
      itemsKey -> response
    )
    resp ++ extra
  }

  def buildSuccessfulResponseByUid[T](uid: Long, itemsKey: String, response: JsValue, extra: JsObject = Json.obj()): JsValue =
    buildSuccessfulResponse("uid", Json.toJson(uid), itemsKey, response, extra)

  def buildJsonErrorResponse[T](form: Form[T]) = {
    val errors = (for (e <- form.errors) yield e.key -> e.messages).toMap
    Json.obj(
      "status" -> "error",
      "errors" -> errors
    )
  }

  def withForm[A, T](unboundForm: Form[T])(success: T => Future[JsValue])(implicit request: Request[A]): Future[Result] = {
    val r = unboundForm.bindFromRequest().fold[Future[JsValue]](
      hasErrors = {
        form => Future.successful(buildJsonErrorResponse(form))
      },
      success = success
    )
    r.map(response => Ok(response))
  }

  def splitText(string: String, delimiter: Char=',', ignoreEmpty: Boolean=true): List[String] = {
    val splitted = string.split(delimiter)
    (if (ignoreEmpty) splitted.filter(_.length > 0) else splitted).toList
  }
}
