package ru.yandex.passport.historydb.api.controllers

import play.api.libs.concurrent.Execution.Implicits.defaultContext
import play.api.mvc.Controller
import play.api.Play.current
import ru.yandex.passport.historydb.api.actions.ErrorHandler
import ru.yandex.passport.historydb.api.storage.HistoryDB

import scala.concurrent.Future
import scala.io.Source
import scala.util.{Try, Success, Failure}


object System extends Controller with HistorydbController {
  val LASTAUTH_UID = 10

  def ping = ErrorHandler.async { implicit request =>
    val pingFilename = current.configuration.getString("historydb.api.ping").get

    val reader = () => {
      val f = Source.fromFile(pingFilename)
      val contents = f.getLines()
      f.close()
      contents
    }
    val pingContent = Try(reader())
    pingContent match {
      case Success(v) => {
        val lastauth = Future(HistoryDB.lastauth(LASTAUTH_UID))(hbaseContext)
        lastauth.map(lastauth => {
          Ok("Pong\n")
        })
      }
      case Failure(e) => Future.successful(Forbidden(f"ping.html is not available: $e%s"))
    }
  }

}
