package ru.yandex.passport.historydb.api.controllers.mail

import play.api.data.Form
import play.api.data.Forms._
import play.api.libs.concurrent.Execution.Implicits.defaultContext
import play.api.libs.json.Json
import play.api.mvc.Controller
import ru.yandex.passport.historydb.api.actions.{ProtectedAction, ErrorHandler, PermissionCheckAction}
import ru.yandex.passport.historydb.api.controllers.HistorydbController
import ru.yandex.passport.historydb.api.json.HistoryDBJson._
import ru.yandex.passport.historydb.api.storage.HistoryDB

import scala.concurrent.Future


object Lastauth extends Controller with HistorydbController{
  val GRANTS = List(
    "mail.lastauth"
  )

  case class lastauthRequest(uid: Long, corp: Boolean)

  val lastauthForm = Form(
    mapping(
      "uid" -> longNumber(min=0),
      "corp" -> default(boolean, false)
    )(lastauthRequest.apply)(lastauthRequest.unapply)
  )

  def lastauth = (ErrorHandler andThen ProtectedAction andThen PermissionCheckAction(GRANTS)).async { implicit request =>
    withForm(lastauthForm) { form =>
      val lastauth = Future(HistoryDB.mailLastauth(form.uid, form.corp))(hbaseContext)
      lastauth.map(lastauth => {
        buildSuccessfulResponseByUid(form.uid, "lastauth", Json.toJson(lastauth))
      })
    }
  }
}
