package ru.yandex.passport.historydb.api.controllers.mail

import play.api.data.Form
import play.api.data.Forms._
import play.api.libs.concurrent.Execution.Implicits.defaultContext
import play.api.libs.json.Json
import play.api.mvc.Controller
import ru.yandex.passport.historydb.api.actions.{ProtectedAction, ErrorHandler, PermissionCheckAction}
import ru.yandex.passport.historydb.api.controllers.HistorydbController
import ru.yandex.passport.historydb.api.json.HistoryDBJson._
import ru.yandex.passport.historydb.api.storage.HistoryDB

import scala.concurrent.Future


object MailSessionLastauth extends Controller with HistorydbController {
  val GRANTS = List(
    "mail.smart_notification"
  )

  val DEFAULT_LIMIT = 500

  case class mailSessionLastauthRequest(uid: Long, corp: Boolean, sessions: String)

  val mailSessionLastauthForm = Form(
    mapping(
      "uid" -> longNumber(min=0),
      "corp" -> default(boolean, false),
      "sessions" -> text
    )(mailSessionLastauthRequest.apply)(mailSessionLastauthRequest.unapply)
  )

  def mailSessionLastauth = (ErrorHandler andThen ProtectedAction andThen PermissionCheckAction(GRANTS)).async { implicit request =>
    withForm(mailSessionLastauthForm) { form =>
      val aliveSessions = form.sessions.split(',').toList.filter(_.length > 0)
      val smartNotifications = Future(HistoryDB.mailSessionLastauth(form.uid, aliveSessions, form.corp, Some(DEFAULT_LIMIT)))(hbaseContext)
      smartNotifications.map(smartNotifications => {
        buildSuccessfulResponseByUid(form.uid, "items", Json.toJson(smartNotifications))
      })
    }
  }

}
