package ru.yandex.passport.historydb.api.controllers.passport

import play.api.data.Form
import play.api.data.Forms.{longNumber, mapping}
import play.api.libs.concurrent.Execution.Implicits.defaultContext
import play.api.libs.json.Json
import play.api.mvc._
import ru.yandex.passport.historydb.api.actions.{ProtectedAction, ErrorHandler, PermissionCheckAction}
import ru.yandex.passport.historydb.api.controllers.HistorydbController
import ru.yandex.passport.historydb.api.json.HistoryDBJson._
import ru.yandex.passport.historydb.api.storage.HistoryDB

import scala.concurrent.Future


object Lastauth extends Controller with HistorydbController {
  val GRANTS = List(
      "account.lastauth"
  )

  case class lastauthRequest(uid: Long)

  val lastauthForm = Form(
    mapping(
      "uid" -> longNumber(min=0)
    )(lastauthRequest.apply)(lastauthRequest.unapply)
  )

  def lastauth = (ErrorHandler andThen ProtectedAction andThen PermissionCheckAction(GRANTS)).async { implicit request =>
    withForm(lastauthForm) {form =>
      val lastauth = Future(HistoryDB.lastauth(form.uid))(hbaseContext)
      lastauth.map(lastauth => {
        buildSuccessfulResponseByUid(form.uid, "lastauth", Json.toJson(lastauth))
      })
    }
  }
}
