package ru.yandex.passport.historydb.api.json.api_v2

import ru.yandex.passport.historydb.api.transformers.auths.AggregatedEntries.{AuthEntry,AggregatedAuthEntry}

object AggregatedAuthEntryAdapter {
  def convert(auth_entry: AggregatedAuthEntry): Option[(AuthEntry, Option[List[Double]], Long)] = {
    val timestamps: Option[List[Double]] = auth_entry.value match {
      case Some(value) => Some(value.map(_.timestamp))
      case None => None
    }

    Some((auth_entry.auth, timestamps, auth_entry.count))
  }
}
