package ru.yandex.passport.historydb.api.json.api_v3

import ru.yandex.passport.historydb.api.transformers.auths.AggregatedEntries.{AuthEntry,AggregatedAuthEntry}
import ru.yandex.passport.historydb.api.storage.AggregatedAuthValue

object AggregatedAuthEntryAdapter {
  def convert(auth_entry: AggregatedAuthEntry): Option[(AuthEntry, Option[List[AggregatedAuthValue]], Long)] = {
    val authentications: List[AggregatedAuthValue] = auth_entry.value.getOrElse(List())

    Some((auth_entry.auth, Some(authentications), auth_entry.count))
  }
}
