package ru.yandex.passport.historydb.api.transformers.auths

import ru.yandex.passport.historydb.api.storage.AggregatedAuthValue

package object AggregatedEntries {

  case class IpEntry(
    AS: Option[Int],
    geoid: Option[Int],
    ip: Option[String]
   )


  case class BrowserEntry(
    name: Option[String],
    version: Option[String],
    yandexuid: Option[String]
  )


  case class OSEntry(
    name: Option[String],
    version: Option[String]
  )

  case class TokenEntry(
    clientId: Option[String],
    tokenId: Option[String],
    deviceId: Option[String],
    deviceName: Option[String],
    scopes: Option[String],
    AP: Option[Boolean]
  )

  case class AuthEntry(
    authtype: String,
    status: Option[String],
    ip: Option[IpEntry],
    os: Option[OSEntry],
    browser: Option[BrowserEntry],
    token: Option[TokenEntry]
  )

  case class AggregatedAuthEntry(
    auth: AuthEntry,
    value: Option[List[AggregatedAuthValue]],
    count: Long
  )

  case class AggregatedAuthDayEntry(
    timestamp: Long, // Begin of the day
    auths: List[AggregatedAuthEntry]
  )

}