package ru.yandex.passport.historydb.api.transformers.auths

import ru.yandex.passport.historydb.api.storage.Auth
import ru.yandex.passport.historydb.api.transformers.auths.AggregatedEntries._

import scala.collection.mutable.{ListBuffer, Map}


object RuntimeAggregated {

  def ipEntryFromAuth(auth: Auth): IpEntry = {
    IpEntry(
      auth.values.get("ip.as_list").map(_.replace("AS", "").toInt),
      auth.values.get("ip.geoid").map(_.toInt),
      auth.values.get("user_ip")
    )
  }

  def browserEntryFromAuth(auth: Auth): BrowserEntry = {
    BrowserEntry(
      auth.values.get("browser.name"),
      auth.values.get("browser.version"),
      auth.values.get("yandexuid")
    )
  }

  def osEntryFromAuth(auth: Auth): OSEntry = {
    OSEntry(
      auth.values.get("os.name"),
      auth.values.get("os.version")
    )
  }

  def authEntryFromAuth(auth: Auth): AuthEntry = {
    AuthEntry(
      auth.values.getOrElse("type", "unknown"),
      auth.values.get("status"),
      Some(ipEntryFromAuth(auth)),
      Some(osEntryFromAuth(auth)),
      Some(browserEntryFromAuth(auth)),
      None
    )
  }

  def aggregate(auths: List[Auth]): List[AggregatedAuthDayEntry] = {
    // TODO: Simplify this code
    if (auths.isEmpty)
      return List()

    // auths отсортирован по убыванию Auth.timestamp
    val result = ListBuffer[AggregatedAuthDayEntry]()

    var currentDayBegin = 0
    var currentDayMap = Map[AuthEntry, Long]().withDefaultValue(0)
    for (auth <- auths) {
      val roundTimestamp = auth.timestamp.toInt
      val roundToDayBeginTimestamp = roundTimestamp - roundTimestamp % (60 * 60 * 24)
      if (currentDayBegin == 0)
        currentDayBegin = roundToDayBeginTimestamp
      else if (roundToDayBeginTimestamp != currentDayBegin) {
        result += AggregatedAuthDayEntry(
          currentDayBegin,
          currentDayMap.map {
            case (authEntry, count) => AggregatedAuthEntry(authEntry, None, count)
          }.toList
        )
        currentDayMap = Map[AuthEntry, Long]() .withDefaultValue(0)
        currentDayBegin= roundToDayBeginTimestamp
      }
      currentDayMap(authEntryFromAuth(auth)) += 1
    }
    if (currentDayMap.nonEmpty) {
      result += AggregatedAuthDayEntry(
        currentDayBegin,
        currentDayMap.map {
          case (authEntry, count) => AggregatedAuthEntry(authEntry, None, count)
        }.toList
      )
    }
    result.toList
  }
}
