package ru.yandex.passport.historydb.api.transformers.sms

import ru.yandex.passport.historydb.api.storage.{HistoryDBUtil, SmsEvent}

import scala.collection.mutable
import scala.collection.mutable.ListBuffer


object GroupByGlobalId {

  def aggregateAndFilter(smsEvents: List[SmsEvent], fromTs: Long, toTs: Long): Map[String, List[SmsEvent]] = {
    val globalIds = mutable.Set[String](
      (for {
        event <- smsEvents
        if event.values("action") == HistoryDBUtil.SMS_ENQUEUED_ACTION &&
          fromTs <= event.timestamp && event.timestamp <= toTs
      }
      yield event.globalSmsId): _*
    )

    val result = mutable.Map[String, ListBuffer[SmsEvent]]()
    for {
      event <- smsEvents
      if globalIds.contains(event.globalSmsId)
    } {
      result.get(event.globalSmsId) match {
        case Some(lst) => lst += event
        case _ => result += event.globalSmsId -> ListBuffer(event)
      }
    }

    (result.map { case (globalSmsId, lst) => (globalSmsId -> lst.sortWith(_.timestamp > _.timestamp).toList)}).toMap
  }

}
