package ru.yandex.passport.historydb.api.util

import play.api.{Configuration, Logger}


object BlackboxConfigHolder {
  private var url: String = null
  private var timeoutMs: Int  = 1000

  Logger.info("Create BlackboxConfigHolder")

  def initialize(config: Configuration): Unit = {
    Logger.info("Initialize BlackboxConfigHolder")
    val env = YandexEnv.envType()
    this.url = config.getString(f"blackbox.$env%s.url").get
  }

  def getUrl = url

  def getTimeoutMs = timeoutMs

}
