package ru.yandex.passport.historydb.api.util

import java.nio.file.{Files, Paths}

import play.api.{Configuration, Logger}
import ru.yandex.library.ticket_parser2.{ServiceContext, Version}

object ServiceContextHolder {
  private var _instance: ServiceContext = null
  private var _clientId: Int = _
  private var _tvmKeyringPath: String = _
  private var _url: String = _

  Logger.info("Create ServiceContextHolder")

  def initialize(config: Configuration): Unit = {
    Logger.info("Initialize ServiceContextHolder")

    val env = YandexEnv.envType()
    this._clientId = config.getInt(f"tvm.$env%s.client_id").get
    this._tvmKeyringPath = config.getString(f"tvm.$env%s.tvm_keyring_path").get

    this._instance = new ServiceContext(this._clientId, "AAAA", this.tvmKeys)
  }

  private def tvmKeys = new String(Files.readAllBytes(Paths.get(this._tvmKeyringPath + "/tvm.keys")))

  def resetKeys(): Unit = {
    this.instance().resetKeys(this.tvmKeys)
  }

  def instance() : ServiceContext =
    _instance
}
