package ru.yandex.passport.historydb.api.util

import play.api.Logger

object YandexEnv {
  private var ENV_TYPE: String = null

  val YANDEX_CONFIG_DIR = "/etc/yandex/"
  val YANDEX_ENV_TYPE_FILENAME = YANDEX_CONFIG_DIR + "environment.type"

  def initialize() = {
    Logger.info("Initialize YandexEnv")
    ENV_TYPE = scala.io.Source.fromFile(YANDEX_ENV_TYPE_FILENAME).mkString.stripLineEnd
    Logger.info(f"Environment: $ENV_TYPE%s")
  }

  def envType() = ENV_TYPE
}
