package ru.yandex.passport.historydb.api.validators

import java.net.{InetAddress => JInetAddress}

import com.google.common.net.InetAddresses
import play.api.data.FormError
import play.api.data.format.Formatter

import scala.util.{Success, Try}


object InetAddress {

  implicit val inetAddressFormatter = new Formatter[JInetAddress] {
    def bind(key: String, data: Map[String, String]) = {
      val r = data.get(key)
        .map(ip => Try(InetAddresses.forString(ip)))
      r match {
        case Some(Success(ip)) => Right(ip)
        case _ => Left(Seq(FormError(key, "error.badvalue", Nil)))
      }
    }

    def unbind(key: String, value: JInetAddress) = Map(key -> value.toString)
  }
}
