package ru.yandex.passport.historydb.api.validators

import play.api.data.validation.{Constraint, Invalid, Valid, ValidationError}


object OneOf {
  def apply(allow_values: Seq[String]): Constraint[String] = Constraint("constraints.oneof")({
    plainText =>
      val errors = if (allow_values.contains(plainText)) Nil else Seq(ValidationError("error.unexpected_value"))
      if (errors.isEmpty) {
        Valid
      } else {
        Invalid(errors)
      }
  })
}