package ru.yandex.passport.historydb.api.validators

import play.api.data.FormError
import play.api.data.format.Formatter

sealed abstract class OrderBy

case object OrderByAsc extends OrderBy {
  override def toString = OrderBy.ORDER_BY_ASC
}

case object OrderByDesc extends OrderBy {
  override def toString = OrderBy.ORDER_BY_DESC
}

object OrderBy {
  val ORDER_BY_ASC = "asc"
  val ORDER_BY_DESC = "desc"
  val ORDER_BY_TYPES = List(ORDER_BY_ASC, ORDER_BY_DESC)

  def apply(orderByValue: String): OrderBy = orderByValue match {
    case ORDER_BY_ASC => OrderByAsc
    case ORDER_BY_DESC => OrderByDesc
    case _ => throw new RuntimeException(f"Bad orderByValue: $orderByValue%s")
  }

  implicit val orderByFormatter = new Formatter[OrderBy] {
    def bind(key: String, data: Map[String, String]) = {
      data.get(key)
        .filter(ORDER_BY_TYPES.contains(_))
        .map(OrderBy(_))
        .toRight(Seq(FormError(key, "error.unknown", Nil)))
    }
    def unbind(key: String, value: OrderBy) = Map(key -> value.toString)
  }
}