package ru.yandex.passport.historydb.api.validators

import play.api.data.FormError
import play.api.data.format.Formatter
import ru.yandex.passport.util.net.{Subnet => NSubnet}

import scala.util.{Success, Try}


object Subnet {

  implicit val subnetFormatter = new Formatter[NSubnet] {
    def bind(key: String, data: Map[String, String]) = {
      val r = data.get(key).map(ip => Try(new NSubnet(ip)))
      r match {
        case Some(Success(subnet)) => Right(subnet)
        case e => Left(Seq(FormError(key, "error.badvalue", Nil)))
      }
    }

    def unbind(key: String, value: NSubnet) = Map(key -> value.getNetworkAddress)
  }
}
