package ru.yandex.passport.util;

import org.json.JSONObject;
import ru.yandex.passport.util.net.SubnetManager;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.*;
import java.util.stream.Collectors;

/**
 * Created by ppodolsky on 23/06/2017.
 */
public class Grants {
    private SubnetManager subnetManager = new SubnetManager();
    private Map<String, Set<String>> grants = new HashMap<>();
    private Map<Integer, Set<String>> grantsByClientId = new HashMap<>();
    public void add(String consumer, Integer clientId, List<String> networks, List<String> grants) throws UnknownHostException {
        for (String network : networks) this.subnetManager.add(consumer, network);
        for (String grant : grants) {
            this.grants.putIfAbsent(consumer, new HashSet<>());
            this.grants.get(consumer).add(grant);
            if (clientId != null) {
                this.grantsByClientId.putIfAbsent(clientId, new HashSet<>());
                this.grantsByClientId.get(clientId).add(grant);
            }
        }
    }
    public boolean checkGrant(String consumer, String grant, InetAddress clientIp) {
        if (subnetManager.checkConsumer(consumer, clientIp))
            if (this.grants.get(consumer).contains(grant))
                return true;
        return false;
    }
    public boolean checkGrantForClientId(int clientId, String grant) {
        Set<String> grantsSet = grantsByClientId.get(clientId);
        return (grantsSet != null && grantsByClientId.get(clientId).contains(grant));
    }
    public Set<String> consumerNames() {
        return grants.keySet();
    }
    public static Grants fromFile(String path) throws IOException {
        return fromString(new String(Files.readAllBytes(Paths.get(path))));
    }
    public static Grants fromString(String jsonString) throws UnknownHostException {
        JSONObject obj = new JSONObject(jsonString);
        Grants grants = new Grants();
        for (String consumer : obj.keySet()) {
            JSONObject consumerObject = obj.getJSONObject(consumer);
            JSONObject grantsObject = consumerObject.getJSONObject("grants");
            List<String> fullGrants = new ArrayList<>();
            for (String grantName : grantsObject.keySet())
                fullGrants.addAll(grantsObject.getJSONArray(grantName).toList().stream().map(r -> grantName + "." + r).collect(Collectors.toList()));
            grants.add(
                    consumer,
                    consumerObject.getJSONObject("client").optInt("client_id"),
                    consumerObject.getJSONArray("networks").toList().stream().map(Object::toString).collect(Collectors.toList()),
                    fullGrants
            );
        }
        return grants;
    }
}
