organization  := "ru.yandex.passport"

version       := "0.1"

scalaVersion  := "2.11.6"

name := "historydb-api"

scalacOptions := Seq("-unchecked", "-deprecation", "-feature", "-encoding", "utf8", "-language", "postfixOps")

lazy val root = (project in file(".")).enablePlugins(PlayScala)


resolvers ++= Seq(
  "Yandex artifactory" at "http://artifactory.yandex.net/artifactory/public/",
  "Nexus nginx mirror" at "http://maven.yandex.net/nexus-mirror/content/groups/public",
  "Cloudera" at "https://repository.cloudera.com/artifactory/cloudera-repos/"
)


externalResolvers := Resolver.withDefaultResolvers(resolvers.value, mavenCentral = false)

libraryDependencies ++= Seq(
  "com.google.protobuf" % "protobuf-java" % "2.5.0",
  "org.apache.hbase" % "hbase-client" % "1.0.0-cdh5.4.9" excludeAll(ExclusionRule(organization = "org.slf4j")),
  "org.apache.hbase" % "hbase" % "1.0.0-cdh5.4.9" excludeAll(ExclusionRule(organization = "org.slf4j")),
  "org.apache.hbase" % "hbase-common" % "1.0.0-cdh5.4.9" excludeAll(ExclusionRule(organization = "org.slf4j")),
  "org.apache.hadoop" % "hadoop-client" % "2.6.0-cdh5.4.9" excludeAll(ExclusionRule(organization = "org.slf4j")),
  "org.apache.commons" % "commons-pool2" % "2.3",
  "org.apache.commons" % "commons-collections4" % "4.1",
  "org.json" % "json" % "20170516",
  "org.scalatest" % "scalatest_2.11" % "2.2.4" % "test",
  "ru.yandex.library" % "ticket_parser2" % "2.0.5" from "file:///usr/lib/ticket-parser/ticket_parser2.jar",
  ws
)

dependencyOverrides += "com.google.guava" % "guava" % "15.0"
dependencyOverrides += "org.apache.zookeeper" % "zookeeper" % "3.4.5-cdh5.4.9"

unmanagedResourceDirectories in Compile += baseDirectory.value / "/usr/lib/ticket-parser"

includeFilter in (Compile, unmanagedResourceDirectories):= ".so"

Revolver.settings

mergeStrategy in assembly <<= (mergeStrategy in assembly) { mergeStrategy => {
    case entry => {
      val strategy = mergeStrategy(entry)
      if (strategy == MergeStrategy.deduplicate) MergeStrategy.first
      else strategy
    }
  }
}

import sbtprotobuf.{ProtobufPlugin=>PB}

Seq(PB.protobufSettings: _*)

assemblyJarName in assembly := "historydb-api.jar"
