# -*- coding: utf-8 -*-
from fabric.api import env
from passport_ci.buildfarm import *
from passport_ci.development import *
from robe import (
    debian,
    venv,
)

env.robe.projects = {
    'historydb-cleaner': {
        'path': '.',
        'use_global_site_packages': True,
    },
}
env.robe.dev_dir = 'venv'
env.robe.venv.dev_requirements_file = 'requirements-dev.txt'
env.robe.debian.repository = 'passport-precise'
env.robe.venv.accelerator = 'wheel'
env.robe.venv.quiet_install = False

env.robe.venv.pip_version = '9.0.1'
env.robe.venv.wheel_version = '0.31.1'

env.passport.pypi_release_dirs = ['.']
env.passport.git = [
    {
        'dir': '.',
        'owner': 'passport',
        'repository': 'historydb-cleaner',
    },
]
