# -*- coding: utf-8 -*-

import logging
import logging.config
import os
import socket

import yenv


def is_debug():
    _current_user = os.environ.get('USER', os.environ.get('LOGNAME', 'root'))
    return yenv.type == 'development' and _current_user not in ('root', 'www-data')


CURRENT_FQDN = socket.getfqdn()

MAX_AUTHS_REGION_AGE = (3 * 366 + 60) * 24 * 3600
if CURRENT_FQDN.startswith('kvs-s') or CURRENT_FQDN.startswith('kvs-i'):
    # В Сасово и Ивантеевке храним за 2 года
    MAX_AUTHS_REGION_AGE = (2 * 366 + 60) * 24 * 3600


REGIONS_STATS_PATH = '/usr/lib/yandex/historydb-cleaner/RegionsStats.rb'
BASE_LOG_PATH = '/var/log/yandex/historydb-cleaner/'
if is_debug():
    REGIONS_STATS_PATH = './scripts/RegionsStats.rb'
    BASE_LOG_PATH = '.'


HBASE_SHELL_LOG = os.path.join(BASE_LOG_PATH, 'hbase-shell.log')


def build_logging_config(path, debug=False):
    config = {
        'version': 1,
        'disable_existing_loggers': False,
        'formatters': {
            'default': {
                'format': '%(process)d %(asctime)s %(name)-15s %(levelname)-10s %(message)s',
            },
        },
        'root': {
            'handlers': ['historydb_cleaner.info', 'historydb_cleaner.error'],
            'level': 'DEBUG',
        },
        'handlers': {
            'console': {
                'class': 'logging.StreamHandler',
                'level': 'DEBUG',
                'formatter': 'default',
            },
            'historydb_cleaner.info': {
                'class': 'ylog.handlers.OSFileHandler',
                'filename': os.path.join(path, 'info.log'),
                'formatter': 'default',
                'level': 'INFO',
            },
            'historydb_cleaner.error': {
                'class': 'ylog.handlers.OSFileHandler',
                'filename': os.path.join(path, 'error.log'),
                'formatter': 'default',
                'level': 'ERROR',
            },
        },
    }

    if debug:
        config['root']['handlers'].append('console')

    return config


LOGGING = build_logging_config(BASE_LOG_PATH, debug=is_debug())
logging.config.dictConfig(LOGGING)
