#!/usr/bin/hbase org.jruby.Main
# Для работы нужно положить javax.json-1.0.4.jar в /usr/lib/hbase/lib/ (http://central.maven.org/maven2/org/glassfish/javax.json/1.0.4/javax.json-1.0.4.jar)
# Как запускать: hbase org.jruby.Main RegionsStats.rb
# http://docs.oracle.com/middleware/1213/wls/WLPRG/java-api-for-json-proc.htm#WLPRG1062


require 'java'
require 'net/http'
require 'ostruct'

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.io.StringWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.util.Bytes;
import javax.json.Json;

log_level = org.apache.log4j.Level::ERROR
org.apache.log4j.Logger.getLogger("org.apache.zookeeper").setLevel(log_level)
org.apache.log4j.Logger.getLogger("org.apache.hadoop.hbase").setLevel(log_level)

config = HBaseConfiguration.create
config.set 'fs.default.name', config.get(HConstants::HBASE_DIR)


admin = nil
while true
  begin
    admin = HBaseAdmin.new config
    break
  rescue MasterNotRunningException => e
    print 'Waiting for master to start...\n'
    sleep 1
  end
end
result = Hash.new
clusterStatus = admin.getClusterStatus
servers = clusterStatus.getServers

jsonModel = Json.createObjectBuilder()
hostStats = Json.createArrayBuilder()
servers.each {|server|
        size=0
        count =0
        serverLoad = clusterStatus.getLoad(server).getRegionsLoad().entrySet()
        serverLoad.each{ |entry|
                info = OpenStruct.new
                info.storeSize = entry.getValue.getStorefileSizeMB
                info.storeCount = entry.getValue.getStorefiles
                info.readReqCount = entry.getValue.getReadRequestsCount
                info.writeReqCount = entry.getValue.getWriteRequestsCount
                result[entry.getValue.getNameAsString] = info
                size = size + entry.getValue.getStorefileSizeMB
                count = count + 1
        }
        hostStat = Json.createObjectBuilder()
        hostStat.add("name", server.getHostname).add("regionCount", count).add("totalSize", size)
        hostStats.add(hostStat)
}
jsonModel.add("hostStats", hostStats)

regionStats = Json.createObjectBuilder()
result.each { |k,v|
        regionStats.add(k,
            Json.createObjectBuilder().add("storeSize", v.storeSize).add("storeCount", v.storeCount).add("readReqCount", v.readReqCount).add("writeReqCount", v.writeReqCount))
}
jsonModel.add("regionStats", regionStats)

jsonModel = jsonModel.build()

stWriter = StringWriter.new()
jsonWriter = Json.createWriter(stWriter)
jsonWriter.writeObject(jsonModel)
jsonWriter.close()

jsonData = stWriter.toString()
STDOUT.write jsonData
