organization  := "ru.yandex.passport"

version       := "0.1"

scalaVersion  := "2.11.5"

scalacOptions := Seq("-unchecked", "-deprecation", "-feature", "-encoding", "utf8")

libraryDependencies ++= {
  val akkaV = "2.3.9"
  val sprayV = "1.3.2"
  Seq(
    "io.spray"               %%  "spray-can"     % sprayV,
    "io.spray"               %%  "spray-routing" % sprayV,
    "io.spray"               %%  "spray-testkit" % sprayV  % "test",
    "io.spray"               %%  "spray-json"    % sprayV,
    "com.typesafe.akka"      %%  "akka-actor"    % akkaV,
    "com.typesafe.akka"      %%  "akka-slf4j"    % akkaV,
    "com.datastax.cassandra" % "cassandra-driver-core" % "2.1.3" excludeAll(
      ExclusionRule(organization = "org.xerial.snappy", artifact = "snappy-java"),
      ExclusionRule(organization = "org.slf4j", artifact = "slf4j-log4j12"),
      ExclusionRule(organization = "log4j", artifact = "log4j")
    ),
    "ch.qos.logback" % "logback-classic" % "1.1.2",
    "org.xerial.snappy"       % "snappy-java"           % "1.1.1.3",
    "com.typesafe.akka"      %%  "akka-testkit"  % akkaV   % "test",
    "org.specs2"             %%  "specs2-core"   % "2.3.11" % "test"
  )
}

Revolver.settings

assemblyJarName in assembly := "passport-ufo.jar"

mainClass in assembly := None

mainClass in packageBin := None

mainClass in Compile := None

mainClass in run := None
