#include "argon.h"

#include "mem_pool.h"

namespace NPassport::NArgon {
    TArgon2Factory::TArgon2Factory(ui32 hashlen)
        : Hashlen_(hashlen)
    {
    }

    TArgon2Factory::TContext TArgon2Factory::Get(const TStringBuf secret, ui32 tCost, ui32 mCost) {
        const ui32 THREAD_COUNT = 1;

        TArgon2Factory::TContext res;
        res.ArgonCtx_ = Argonish_.Create(
            NArgonish::EArgon2Type::Argon2d,
            tCost,
            mCost,
            THREAD_COUNT,
            (ui8*)secret.data(),
            secret.size());
        res.Hashlen_ = Hashlen_;

        return res;
    }

    TString TArgon2Factory::TContext::MakeHash(const TStringBuf pwd, const TStringBuf salt, const TStringBuf ad) const {
        TString out(Hashlen_, 0);

        TMemPool::TPtrHandle mem = TMemPool::GetHandle(ArgonCtx_->GetMemorySize());
        ArgonCtx_->HashWithCustomMemory(
            (ui8*)mem.Ptr.get(),
            ArgonCtx_->GetMemorySize(),
            (ui8*)pwd.data(),
            pwd.size(),
            (ui8*)salt.data(),
            salt.size(),
            (ui8*)out.data(),
            Hashlen_,
            (ui8*)ad.data(),
            ad.size());

        return out;
    }

    bool TArgon2Factory::TContext::VerifyHash(const TStringBuf pwd, const TStringBuf hash, const TStringBuf salt, const TStringBuf ad) const {
        TMemPool::TPtrHandle mem = TMemPool::GetHandle(ArgonCtx_->GetMemorySize());
        return ArgonCtx_->VerifyWithCustomMemory((ui8*)mem.Ptr.get(),
                                                 ArgonCtx_->GetMemorySize(),
                                                 (ui8*)pwd.data(),
                                                 pwd.size(),
                                                 (ui8*)salt.data(),
                                                 salt.size(),
                                                 (ui8*)hash.data(),
                                                 hash.size(),
                                                 (ui8*)ad.data(),
                                                 ad.size());
    }
}
