#pragma once

#include <library/cpp/digest/argonish/argon2.h>

#include <util/generic/strbuf.h>
#include <util/generic/string.h>

#include <memory>

namespace NPassport::NArgon {
    class TArgon2Factory {
    public:
        explicit TArgon2Factory(ui32 hashlen);

        class TContext {
        public:
            TString MakeHash(const TStringBuf pwd, const TStringBuf salt, const TStringBuf ad = TStringBuf()) const;
            bool VerifyHash(const TStringBuf pwd, const TStringBuf hash, const TStringBuf salt, const TStringBuf ad = TStringBuf()) const;

        private:
            THolder<NArgonish::IArgon2Base> ArgonCtx_;
            ui32 Hashlen_ = 0U;
            friend class TArgon2Factory;
        };
        TContext Get(const TStringBuf secret,
                     ui32 tCost,  // number of passes
                     ui32 mCost); // amount of memory requested (KB)

    private:
        const NArgonish::TArgon2Factory Argonish_;
        const ui32 Hashlen_;
    };
}
