#include "mem_pool.h"

#include <util/thread/singleton.h>

#include <map>

namespace NPassport::NArgon {
    using TStorage = std::map<size_t, TMemPool::TPtr>;

    TMemPool::TPtrHandle TMemPool::GetHandle(size_t size) {
        return TPtrHandle(size);
    }

    TMemPool::TPtr TMemPool::Get(size_t size) {
        TStorage& storage = *FastTlsSingleton<TStorage>();

        auto it = storage.find(size);
        if (it == storage.end() || !it->second) {
            return MakePtr(size);
        }

        return std::move(it->second);
    }

    void TMemPool::Put(TPtr buf, size_t size) {
        if (!buf) {
            return;
        }

        TStorage& storage = *FastTlsSingleton<TStorage>();
        storage[size] = std::move(buf);
    }

    TMemPool::TPtr TMemPool::MakePtr(size_t size) {
        return TPtr(new char[size]);
    }

    TMemPool::TPtrHandle::TPtrHandle(size_t size)
        : Ptr(TMemPool::Get(size))
        , Size(size)
    {
    }

    TMemPool::TPtrHandle::~TPtrHandle() {
        try {
            TMemPool::Put(std::move(Ptr), Size);
        } catch (...) {
        }
    }
}
