#pragma once

#include <memory>

namespace NPassport::NArgon {
    // It is thread local memrory pool
    // It allowes to avoid contention between workers
    class TMemPool {
    public:
        using TPtr = std::unique_ptr<char[]>;
        struct TPtrHandle {
            TPtrHandle(size_t size);
            ~TPtrHandle();

            TPtr Ptr;
            const size_t Size;
        };

        static TPtrHandle GetHandle(size_t size);

    private:
        static TPtr Get(size_t size);
        static void Put(TPtr buf, size_t size);

        static TPtr MakePtr(size_t size);
    };
}
