#include <passport/infra/libs/cpp/argon/argon.h>

#include <passport/infra/libs/cpp/utils/string/coder.h>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NArgon;
using namespace NPassport::NUtils;

Y_UNIT_TEST_SUITE(Argon) {
    Y_UNIT_TEST(argonTest) {
        const TString secret("mega_secret_key");
        TArgon2Factory factory(113);
        TArgon2Factory::TContext c = factory.Get(secret, 1, 16);

        const TString p = "ololo";
        const TString s = "abcdefgh";
        const TString h = "FEv1EBnXUZ+Kq4A6PMyV4OkMpdSOFVcCcuu4yGC3A7jbDjF8o66fbWwo4cApCKtYSWzTb95hcdgsAmUWu/KRwkjj8sJq5zrAAGGeHIQGHaIQbVDTkQEd1dUiPGreriMlSUbSwbEUVqWX7l2nK3arPK4=";
        UNIT_ASSERT_VALUES_EQUAL(h, BinToBase64(c.MakeHash(p, s)));

        UNIT_ASSERT(c.VerifyHash(p, Base64ToBin(h), s));
        UNIT_ASSERT(!c.VerifyHash(p, "asdadasad", s));
        UNIT_ASSERT(!c.VerifyHash(p, Base64ToBin(h), "asdadssadas"));
        UNIT_ASSERT(!c.VerifyHash("wrong", Base64ToBin(h), s));

        UNIT_ASSERT(c.VerifyHash(p, Base64ToBin(h), s));
        UNIT_ASSERT(!c.VerifyHash(p, "asdadasad", s));
        UNIT_ASSERT(!c.VerifyHash(p, Base64ToBin(h), "asdadssadas"));
        UNIT_ASSERT(!c.VerifyHash("wrong", Base64ToBin(h), s));
    }

    Y_UNIT_TEST(argonTest2) {
        const TString secret("mega_secret_key2");
        TArgon2Factory factory(13);
        TArgon2Factory::TContext c = factory.Get(secret, 1, 1024);

        const TString p = "mega_password";
        const TString s = "mega_salt";
        const TString h = "7nCy1Mx8LyYlZK17sg==";
        UNIT_ASSERT_VALUES_EQUAL(h, BinToBase64(c.MakeHash(p, s)));

        UNIT_ASSERT(c.VerifyHash(p, Base64ToBin(h), s));
        UNIT_ASSERT(!c.VerifyHash(p, "asdadasad", s));
        UNIT_ASSERT(!c.VerifyHash(p, Base64ToBin(h), "asdadssadas"));
        UNIT_ASSERT(!c.VerifyHash("wrong", Base64ToBin(h), s));

        UNIT_ASSERT(c.VerifyHash(p, Base64ToBin(h), s));
        UNIT_ASSERT(!c.VerifyHash(p, "asdadasad", s));
        UNIT_ASSERT(!c.VerifyHash(p, Base64ToBin(h), "asdadssadas"));
        UNIT_ASSERT(!c.VerifyHash("wrong", Base64ToBin(h), s));
    }

    Y_UNIT_TEST(argonTest3) {
        const TString secret("mega_secret_key");
        TArgon2Factory factory(113);
        TArgon2Factory::TContext c = factory.Get(secret, 1, 16);

        const TString p = "ololo";
        const TString s = "abcdefgh";
        const TString ad = "some_additional_info";
        const TString h = "WHByHVncMlX4UyPA4OR3yifc/06qu+iw/Q6QBrgsY7w4gHqn4epVlta6vTncwPKxHyVDKPng5UIy4NfKAdZwSbTA0s0quo1n1nOFwWYuXc86hrIhTMp5PnVJYelAlLOB0SCU0Knl2dtzCHyBi4J4ZLo=";
        UNIT_ASSERT_VALUES_EQUAL(h, BinToBase64(c.MakeHash(p, s, ad)));

        UNIT_ASSERT(c.VerifyHash(p, Base64ToBin(h), s, ad));
        UNIT_ASSERT(!c.VerifyHash(p, "asdadasad", s, ad));
        UNIT_ASSERT(!c.VerifyHash(p, Base64ToBin(h), "asdadssadas", ad));
        UNIT_ASSERT(!c.VerifyHash("wrong", Base64ToBin(h), s, ad));

        UNIT_ASSERT(c.VerifyHash(p, Base64ToBin(h), s, ad));
        UNIT_ASSERT(!c.VerifyHash(p, "asdadasad", s, ad));
        UNIT_ASSERT(!c.VerifyHash(p, Base64ToBin(h), "asdadssadas", ad));
        UNIT_ASSERT(!c.VerifyHash("wrong", Base64ToBin(h), s, ad));
    }

    Y_UNIT_TEST(argonLimitingCase1) {
        const TString secret = "mega_secret_key";
        TArgon2Factory factory(113);
        TArgon2Factory::TContext c = factory.Get(secret, 1, 16);

        const TString p = "";
        const TString s = "abcdefgh";
        const TString ad = "some_additional_info";
        const TString h = "fNKKhhuWnTr96HX8IVlCzLOTPezF2TzMn8PLyxADLf+1ePpUoU+sWyM6MdUbraE4CDZw1lLvZL6qYC9F4w9YWROUr6cSD3WjO4synj614NX2JBhdXHq15Uf+3uf4Dp0y4B/kmiaRQJUbbx3Oa0mDBuw=";
        UNIT_ASSERT_VALUES_EQUAL(h, BinToBase64(c.MakeHash(p, s, ad)));

        UNIT_ASSERT(c.VerifyHash(p, Base64ToBin(h), s, ad));
        UNIT_ASSERT(!c.VerifyHash(p, "asdadasad", s, ad));
        UNIT_ASSERT(!c.VerifyHash(p, Base64ToBin(h), "asdadssadas", ad));
        UNIT_ASSERT(!c.VerifyHash("wrong", Base64ToBin(h), s, ad));

        TArgon2Factory::TContext c2 = factory.Get(secret, 2, 16);
        const TString h2 = "149ggkQ4vy6ZQeOdQ53ZSjfGof8G2sAShw0wPcH24HGCJ/ZqTgNkUTKBJ6BBNn+XltI/GLZTtkMvX8cdGZef2OCeiL021xrysnOSPtF71QARTDifWYcm89wES6F9lnHoZ6hzP8LzDSws62C8zF4VgTg=";
        UNIT_ASSERT_VALUES_EQUAL(h2, BinToBase64(c2.MakeHash(p, s, ad)));
        UNIT_ASSERT(!c2.VerifyHash(p, Base64ToBin(h), s, ad));

        TArgon2Factory::TContext c3 = factory.Get(secret, 1, 64);
        const TString h3 = "6QB9byj9E27Y8TybK0MEwmKk23yjWFtWBBNAhFV2wrQgIumGF43i4zrwZNuTw54Ajsa9KauH9J/XJJYs02hYezD34PMcIdS90YHpwtHl9N7p3fpKZdnk2DMPsoeZAJ7GToDsPETVXpidQdRXApNsS+w=";
        UNIT_ASSERT_VALUES_EQUAL(h3, BinToBase64(c3.MakeHash(p, s, ad)));
        UNIT_ASSERT(!c3.VerifyHash(p, Base64ToBin(h), s, ad));
    }

    Y_UNIT_TEST(argonLimitingCase2) {
        const TString secret = "mega_secret_key";
        TArgon2Factory factory(113);
        TArgon2Factory::TContext c = factory.Get(secret, 1, 16);

        const TString p = "o";
        const TString s = "abcdefgh";
        const TString ad = "some_additional_info";
        const TString h = "xawdwhdBXlJoLa/IIJjcxHvwtual4Mis5jUfAor2zCtcsG8E+rvEjtL26amhQuMei8/eTT8JSuUg6OclbQ+qKE5T4qYo20E8CARtplBfnYMqNJI5zY/CgwL3t/Y9ksGu+lEm71CcPHPz5TW23qbRMAg=";
        UNIT_ASSERT_VALUES_EQUAL(h, BinToBase64(c.MakeHash(p, s, ad)));

        UNIT_ASSERT(c.VerifyHash(p, Base64ToBin(h), s, ad));
        UNIT_ASSERT(!c.VerifyHash(p, "asdadasad", s, ad));
        UNIT_ASSERT(!c.VerifyHash(p, Base64ToBin(h), "asdadssadas", ad));
        UNIT_ASSERT(!c.VerifyHash("wrong", Base64ToBin(h), s, ad));

        TArgon2Factory::TContext c2 = factory.Get(secret, 2, 16);
        const TString h2 = "mryl8swQRvYeQfzkIuzRFUueyDO3qHL5+XvisyhX2ML94n4uo68NXLArxmXIPDgxvCPnka47mSSC9m27APIJD7PlFBmGtp2zxlnEyYko7F5Ere07IKzknhuT1zG+bkn+ZWH6TAvVoLLXH0AwUBWSMUk=";
        UNIT_ASSERT_VALUES_EQUAL(h2, BinToBase64(c2.MakeHash(p, s, ad)));
        UNIT_ASSERT(!c2.VerifyHash(p, Base64ToBin(h), s, ad));

        TArgon2Factory::TContext c3 = factory.Get(secret, 1, 64);
        const TString h3 = "a8eosHJD/RK5sEKUv1NxEECwv5AUxAPJPg2bAeAnfPqNduP2cIdKL3Iifletc3XC13QJvutJ3TYn5p9558Fmy4Y4/+XWW30otzhmXy1ZIatmHWQ7ByvDAuUvAL0xCwYtiR9xzNUk81OW3B2ZgFBAgZg=";
        UNIT_ASSERT_VALUES_EQUAL(h3, BinToBase64(c3.MakeHash(p, s, ad)));
        UNIT_ASSERT(!c3.VerifyHash(p, Base64ToBin(h), s, ad));
    }

    Y_UNIT_TEST(argonLimitingCase3) {
        const TString secret = "mega_secret_key";
        TArgon2Factory factory(113);
        TArgon2Factory::TContext c = factory.Get(secret, 1, 16);

        const TString p = "megapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmegapwdmega";
        const TString s = "abcdefgh";
        const TString ad = "some_additional_info";
        const TString h = "SQytQeyXmrmLS/xLZkRyiBRR155uLtwPPthU/J5n4Fq2hH/N7KPUhJQPG1qhdJLqfJnHgu/xIGsQVYygc7ajv+awNgIS8rAnoNWdatw61aM+Cdka4xG1Wmpg/sA04QIYjvV7xzhc4JWUxh2N+ZkqqDk=";
        UNIT_ASSERT_VALUES_EQUAL(h, BinToBase64(c.MakeHash(p, s, ad)));

        UNIT_ASSERT(c.VerifyHash(p, Base64ToBin(h), s, ad));
        UNIT_ASSERT(!c.VerifyHash(p, "asdadasad", s, ad));
        UNIT_ASSERT(!c.VerifyHash(p, Base64ToBin(h), "asdadssadas", ad));
        UNIT_ASSERT(!c.VerifyHash("wrong", Base64ToBin(h), s, ad));

        TArgon2Factory::TContext c2 = factory.Get(secret, 2, 16);
        const TString h2 = "Ciw/E46yfl3drUAIm/oL16XZ7QyrIL2NVBYYku0cEQY8jLXREi4L/eDH/nV+IQB1BnOVnVU2WzLbHle2LiufUl2iMT8RaYujkpkWcleA2doyBbcJez1EFsV85e0s4o74Q90V3umWnoJxk6cZ/cp1ipg=";
        UNIT_ASSERT_VALUES_EQUAL(h2, BinToBase64(c2.MakeHash(p, s, ad)));
        UNIT_ASSERT(!c2.VerifyHash(p, Base64ToBin(h), s, ad));

        TArgon2Factory::TContext c3 = factory.Get(secret, 1, 64);
        const TString h3 = "pKRKUroo99eUjFXn+NtVGnaot+yY4tStcqdprzjADNRZwJhfqibFlB3+spvUlMKggB/TvGC25jNGs2ZnYeA75DkFtyM+oQwsPZhCwgyYEC12YIg/uefZ0sVTbVCXzTtI2M2hT8+N2CJwkqH17EUZBbY=";
        UNIT_ASSERT_VALUES_EQUAL(h3, BinToBase64(c3.MakeHash(p, s, ad)));
        UNIT_ASSERT(!c3.VerifyHash(p, Base64ToBin(h), s, ad));
    }

    Y_UNIT_TEST(argonLimitingCase4) {
        const TString secret = "mega_secret_key";
        TArgon2Factory factory(113);
        TArgon2Factory::TContext c = factory.Get(secret, 1, 16);

        const TString p = "ololo";
        const TString s = "abcdefghabcdefghabcdefghabcdefghabcdefghabcdefghabcdefghabcdefghabcdefghabcdefghabcdefghabcdefghabcdefghabcdefghabcdefghabcdefghabcdefghabcdefghabcdefghabcdefghabcdefghabcdefghabcdefghabcdefghabcdefghabcdefghabcdefghabcdefghabcdefghabcdefghabcdefghabcdefgh";
        const TString ad = "some_additional_info";
        const TString h = "ZK5JcK9mgsVKCCq34O0EeB2jpHc4uvGg6p7nSIb5Fia8eAPrmUZA+4FKcYJJXHipLn7FoPQiMBJv3iipMDeHMp+TCV+3yzqAXeVrSizP1gYAAqAP4XygLoKgjMMpDuqgbo+99J8eTuUv/yJMMr95jj4=";
        UNIT_ASSERT_VALUES_EQUAL(h, BinToBase64(c.MakeHash(p, s, ad)));

        UNIT_ASSERT(c.VerifyHash(p, Base64ToBin(h), s, ad));
        UNIT_ASSERT(!c.VerifyHash(p, "asdadasad", s, ad));
        UNIT_ASSERT(!c.VerifyHash(p, Base64ToBin(h), "asdadssadas", ad));
        UNIT_ASSERT(!c.VerifyHash("wrong", Base64ToBin(h), s, ad));

        TArgon2Factory::TContext c2 = factory.Get(secret, 2, 16);
        const TString h2 = "2UHw0Vfx90CTEG1UnsonFxYX/Xj5LW80qKbgymmSykxcpiCWStJHRt+IIDMKd7tooY9B02kvlk2dm3LA66hukcs7nGp39yTRrawLxytP/RVMJ6s3OrARtBIYf9i1ya/hlYnDvMH+w2HOZjm3rnlB+j8=";
        UNIT_ASSERT_VALUES_EQUAL(h2, BinToBase64(c2.MakeHash(p, s, ad)));
        UNIT_ASSERT(!c2.VerifyHash(p, Base64ToBin(h), s, ad));

        TArgon2Factory::TContext c3 = factory.Get(secret, 1, 64);
        const TString h3 = "oAq/tTdg/ky1JiNSsd6wNC0yF6Wmx3qbYwwp4MbEukvk77ytf5kzUqUgeCUabvCWvvrn0v9z3z4pw1KhqRAOJMmtY8HVI0Q1JEGjm4zMxGVyYE/FsXgezfXLygslq74jO7LtSPzyzGbgfLg5NhLlZ/Y=";
        UNIT_ASSERT_VALUES_EQUAL(h3, BinToBase64(c3.MakeHash(p, s, ad)));
        UNIT_ASSERT(!c3.VerifyHash(p, Base64ToBin(h), s, ad));
    }

    Y_UNIT_TEST(argonLimitingCase5) {
        const TString secret = "mega_secret_key";
        TArgon2Factory factory(113);
        TArgon2Factory::TContext c = factory.Get(secret, 1, 16);

        const TString p = "ololo";
        const TString s = "abcdefgh";
        const TString ad = "";
        const TString h = "FEv1EBnXUZ+Kq4A6PMyV4OkMpdSOFVcCcuu4yGC3A7jbDjF8o66fbWwo4cApCKtYSWzTb95hcdgsAmUWu/KRwkjj8sJq5zrAAGGeHIQGHaIQbVDTkQEd1dUiPGreriMlSUbSwbEUVqWX7l2nK3arPK4=";
        UNIT_ASSERT_VALUES_EQUAL(h, BinToBase64(c.MakeHash(p, s, ad)));

        UNIT_ASSERT(c.VerifyHash(p, Base64ToBin(h), s, ad));
        UNIT_ASSERT(!c.VerifyHash(p, "asdadasad", s, ad));
        UNIT_ASSERT(!c.VerifyHash(p, Base64ToBin(h), "asdadssadas", ad));
        UNIT_ASSERT(!c.VerifyHash("wrong", Base64ToBin(h), s, ad));

        TArgon2Factory::TContext c2 = factory.Get(secret, 2, 16);
        const TString h2 = "sX8Q5HaHAT24alE29lLeRNrfmyZyS3SuLg/C36kPVXLzIg3GsVO1II6nOMN6+K+dZCKZxgYVmDhhM9HQMb5QFzdBCFuRLXCeC0fnMXLEWJDoNIorjIu6XbmDS1xN+0w9j2ohUrsYLQD+41HXhU+kJ+8=";
        UNIT_ASSERT_VALUES_EQUAL(h2, BinToBase64(c2.MakeHash(p, s, ad)));
        UNIT_ASSERT(!c2.VerifyHash(p, Base64ToBin(h), s, ad));

        TArgon2Factory::TContext c3 = factory.Get(secret, 1, 64);
        const TString h3 = "TwQpP+7rcU706YuffBZmqhswrZSdWphD6uXAG8mqQVL4eBCIeMrD4TbmsruCxei0W4o8UzBHETCgJQMmjmSx2xMnfdLEWjyTgVOWaytCGrgKj02oIgj69zJj9ETQp4X5l0ugE3TyuS4Xx8PwjXka/DE=";
        UNIT_ASSERT_VALUES_EQUAL(h3, BinToBase64(c3.MakeHash(p, s, ad)));
        UNIT_ASSERT(!c3.VerifyHash(p, Base64ToBin(h), s, ad));
    }

    Y_UNIT_TEST(argonLimitingCase6) {
        const TString secret = "mega_secret_key";
        TArgon2Factory factory(113);
        TArgon2Factory::TContext c = factory.Get(secret, 1, 16);

        const TString p = "ololo";
        const TString s = "abcdefgh";
        const TString ad = "a";
        const TString h = "+JsTrzW9GsqzxX+ps9gvqIIZFYIm4Fves4kjfikE3IIpfXXqtILJeQiF6s5C/txqYf84DwDrHGsqVkBXxWIFkomEqU0BwtibAopjiSQqeHahC5xzmvbbqOL+OMe/7i7sZkXN90H8r1wLbtdSecDVph4=";
        UNIT_ASSERT_VALUES_EQUAL(h, BinToBase64(c.MakeHash(p, s, ad)));

        UNIT_ASSERT(c.VerifyHash(p, Base64ToBin(h), s, ad));
        UNIT_ASSERT(!c.VerifyHash(p, "asdadasad", s, ad));
        UNIT_ASSERT(!c.VerifyHash(p, Base64ToBin(h), "asdadssadas", ad));
        UNIT_ASSERT(!c.VerifyHash("wrong", Base64ToBin(h), s, ad));

        TArgon2Factory::TContext c2 = factory.Get(secret, 2, 16);
        const TString h2 = "6eIh6uwa9DMq9gSDjf4HSGAvu2SZQB+4Zyt0TjauRsMwHQzHKLS1rOppMFQOpShxmtkOPgP838LGh6lHuHzeihcflxRZlsUeGorWX3nPfc6HtqL6FHmbN0m60ScCNyMjN9rT8feeod6J4dK6wmSHzhM=";
        UNIT_ASSERT_VALUES_EQUAL(h2, BinToBase64(c2.MakeHash(p, s, ad)));
        UNIT_ASSERT(!c2.VerifyHash(p, Base64ToBin(h), s, ad));

        TArgon2Factory::TContext c3 = factory.Get(secret, 1, 64);
        const TString h3 = "6E48GqFvH+V7c6KuzXGTtv0hi5h9/peyyitFqzeiUGIUpipK7dV3TH0aHwe8q2ikOkA92lkFCet4mwgFxZ4zQPOeyAlWN4YPJuXXrCpuqr4+tY9O7LO7d7+3Wq88CnBqndFNrHgpNvgCtz+t5VkRulI=";
        UNIT_ASSERT_VALUES_EQUAL(h3, BinToBase64(c3.MakeHash(p, s, ad)));
        UNIT_ASSERT(!c3.VerifyHash(p, Base64ToBin(h), s, ad));
    }

    Y_UNIT_TEST(argonLimitingCase7) {
        const TString secret = "mega_secret_key";
        TArgon2Factory factory(113);
        TArgon2Factory::TContext c = factory.Get(secret, 1, 16);

        const TString p = "ololo";
        const TString s = "abcdefgh";
        const TString ad = "some_additional_info_some_additional_info_some_additional_info_some_additional_info_some_additional_info_some_additional_info_some_additional_info_some_additional_info_some_additional_info_some_additional_info_some_additional_info_some_additional_info_some";
        const TString h = "2DzJuHLh8gvvkgOmbY7ZuhSDg5JmYyrsAUHD2GkyNbWYlhUctod6UyHjlAoXQiE2vMcuIdMHRcftCbfKZ7C0kFVaKtI9LIU57pP5HA+zJVmjhdEzeumxsh7mxIB96Dw8JttxqUbvP57S/p6CzIUiaAI=";
        UNIT_ASSERT_VALUES_EQUAL(h, BinToBase64(c.MakeHash(p, s, ad)));

        UNIT_ASSERT(c.VerifyHash(p, Base64ToBin(h), s, ad));
        UNIT_ASSERT(!c.VerifyHash(p, "asdadasad", s, ad));
        UNIT_ASSERT(!c.VerifyHash(p, Base64ToBin(h), "asdadssadas", ad));
        UNIT_ASSERT(!c.VerifyHash("wrong", Base64ToBin(h), s, ad));

        TArgon2Factory::TContext c2 = factory.Get(secret, 2, 16);
        const TString h2 = "fa/r5ptp6nyn7oQW0E58GENtu8O6CzhdEEILqF99asIt69T66goNBIjtAJrB96K8ibx5HOPw9Yw5OhgvJJl0LPs0YXQTldIsHkMStqu41GkSirIaXrSVMVdA5SbkgfEuvVjKLjVWmlR/Y3ci+3JCDsk=";
        UNIT_ASSERT_VALUES_EQUAL(h2, BinToBase64(c2.MakeHash(p, s, ad)));
        UNIT_ASSERT(!c2.VerifyHash(p, Base64ToBin(h), s, ad));

        TArgon2Factory::TContext c3 = factory.Get(secret, 1, 64);
        const TString h3 = "7fTzy42yezzRpz6Qy1RB8LEs/K/YNIcHDDRJMvG7bvySyj0OHZI6kesUuCDnV3g8lL58j9IpYjAD2OKpjppP7clQsbqOFElfaovgJYGjJv3ioKTQiprJp3J+LIkCYlH90HcmF8zsJbYN4z4RTiyQCDE=";
        UNIT_ASSERT_VALUES_EQUAL(h3, BinToBase64(c3.MakeHash(p, s, ad)));
        UNIT_ASSERT(!c3.VerifyHash(p, Base64ToBin(h), s, ad));
    }
}
