#include <passport/infra/libs/cpp/argon/argon.h>

#include <passport/infra/libs/cpp/utils/string/coder.h>

#include <util/generic/string.h>

using namespace NPassport::NArgon;

static const TString ALPHA = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
const char DEFAULT = '.';

int main(int, char**) {
    TArgon2Factory f(32);
    auto ctx = f.get("secret", 1, 2048);

    size_t pwd_c = 6;
    size_t salt_c = 16;
    size_t ad_c = 8;

    ui64 i = 0;

    TString pwd(pwd_c, DEFAULT);
    for (size_t pwd_i = 0; pwd_i < pwd_c; ++pwd_i) {
        for (char pwd_l : ALPHA) {
            pwd[pwd_i] = pwd_l;

            TString salt(salt_c, DEFAULT);
            for (size_t salt_i = 0; salt_i < salt_c; ++salt_i) {
                for (char salt_l : ALPHA) {
                    salt[salt_i] = salt_l;

                    TString ad(ad_c, DEFAULT);
                    for (size_t ad_i = 0; ad_i < ad_c; ++ad_i) {
                        for (char ad_l : ALPHA) {
                            ad[ad_i] = ad_l;

                            Cout << bin2base64url(ctx.makeHash(pwd, salt, ad), false) << Endl;
                            if (++i == 100000) {
                                // Cout << i << Endl;
                                return 0;
                            }
                        }
                    }
                }
            }
        }
    }

    return 0;
}
