#include <passport/infra/libs/cpp/argon/argon.h>

#include <passport/infra/libs/cpp/utils/string/coder.h>

#include <library/cpp/resource/resource.h>
#include <library/cpp/testing/unittest/registar.h>

#include <util/generic/string.h>
#include <util/system/info.h>
#include <util/thread/pool.h>

#include <istream>

using namespace NPassport::NArgon;
using namespace NPassport::NUtils;

Y_UNIT_TEST_SUITE(PasspUtilsCrypto) {
    static const TString ALPHA = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    const char DEFAULT = '.';

    static void Run(TThreadPool& threads, TArgon2Factory::TContext& ctx) {
        const size_t pwd_c = 6;
        const size_t salt_c = 16;
        const size_t ad_c = 8;

        ui64 i = 0;

        const TString fileBody = NResource::Find("/argon_hashes_1_2048");
        TStringInput stream(fileBody);
        TString line;

        TString pwd(pwd_c, DEFAULT);
        for (size_t pwd_i = 0; pwd_i < pwd_c; ++pwd_i) {
            for (char pwd_l : ALPHA) {
                pwd[pwd_i] = pwd_l;

                TString salt(salt_c, DEFAULT);
                for (size_t salt_i = 0; salt_i < salt_c; ++salt_i) {
                    for (char salt_l : ALPHA) {
                        salt[salt_i] = salt_l;

                        TString ad(ad_c, DEFAULT);
                        for (size_t ad_i = 0; ad_i < ad_c; ++ad_i) {
                            for (char ad_l : ALPHA) {
                                ad[ad_i] = ad_l;

                                line = stream.ReadLine();

                                threads.SafeAddFunc([&ctx, pwd, salt, ad, i, line]() {
                                    TString errMsg;
                                    errMsg.append("pwd=").append(pwd).append(". ");
                                    errMsg.append("salt=").append(salt).append(". ");
                                    errMsg.append("ad=").append(ad).append(". ");
                                    errMsg.append("line=").append(IntToString<10>(i)).append(". ");

                                    UNIT_ASSERT_VALUES_EQUAL_C(line,
                                                               Bin2base64url(ctx.MakeHash(pwd, salt, ad), false),
                                                               errMsg);

                                    UNIT_ASSERT_C(ctx.VerifyHash(pwd, Base64url2bin(line), salt, ad),
                                                  errMsg);
                                });

                                if (++i == 100000) {
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    Y_UNIT_TEST(test) {
        static const TString secret("secret");
        TArgon2Factory f(32);
        TArgon2Factory::TContext ctx = f.Get(secret, 1, 2048);

        TThreadPool threads;
        threads.Start(NSystemInfo::NumberOfCpus());
        Run(threads, ctx);
        threads.Stop();
    }
}
