#include "combined_key_id.h"

#include <util/string/cast.h>

namespace NPassport::NAuth {
    // PASSP-32788
    static constexpr ui32 OFFSET = 10000000;
    static constexpr ui64 MAX_GAMMA_ID = std::numeric_limits<ui32>::max() / OFFSET;

    TCombinedKeyId::TCombinedKeyId(ui32 num)
        : GammaId_(num / OFFSET)
        , RandomId_(num % OFFSET)
    {
    }

    TCombinedKeyId::TCombinedKeyId(TGammaId gammaId, ui32 randomId)
        : GammaId_(gammaId)
        , RandomId_(randomId)
    {
        Y_ENSURE(gammaId <= MAX_GAMMA_ID,
                 "gammaId=" << gammaId << " is too big, max=" << MAX_GAMMA_ID << ", randomid=" << randomId);
    }

    ui32 TCombinedKeyId::AsNumber() const {
        return RandomId_ + OFFSET * GammaId_;
    }

    TString TCombinedKeyId::AsString() const {
        return ToString(AsNumber());
    }

    bool TCombinedKeyId::operator==(const TCombinedKeyId& o) const {
        return GammaId_ == o.GammaId_ && RandomId_ == o.RandomId_;
    }
}
