#pragma once

#include <util/generic/string.h>

namespace NPassport::NAuth {
    using TGammaId = ui16;

    struct TCombinedKeyId {
        TCombinedKeyId() = default;
        TCombinedKeyId(ui32 num);
        TCombinedKeyId(TGammaId gammaId, ui32 randomId);

        ui32 AsNumber() const;
        TString AsString() const;

        TGammaId GammaId() const {
            return GammaId_;
        }

        ui32 RandomId() const {
            return RandomId_;
        }

        bool operator==(const TCombinedKeyId& o) const;

    private:
        TGammaId GammaId_ = 0;
        ui32 RandomId_ = 0;
    };
}
