#pragma once

#include "combined_key_id.h"

#include <library/cpp/string_utils/secret_string/secret_string.h>

#include <util/datetime/base.h>

#include <memory>
#include <optional>
#include <set>

namespace NPassport::NAuth {
    enum class EEnitityType {
        Session,
        OAuth,
        Smth,
        Other,
    };

    struct TGamma {
        std::optional<TInstant> ValidUpperBound;
        std::set<EEnitityType> TypesToCheck;
        TGammaId Id = 0;

        // TSecretString is copy-only object and copying is expensive
        std::shared_ptr<NSecretString::TSecretString> Body;

        bool operator==(const TGamma& o) const {
            if (!(ValidUpperBound == o.ValidUpperBound &&
                  TypesToCheck == o.TypesToCheck &&
                  Id == o.Id &&
                  (bool)Body == (bool)o.Body)) {
                return false;
            }

            if (Body) {
                return (TStringBuf)*Body == (TStringBuf)*o.Body;
            }
            return true;
        }
    };
}
