#pragma once

#include "combined_key_id.h"
#include "gamma.h"
#include "key_with_gamma.h"

#include <passport/infra/libs/cpp/auth_core/random.h>

#include <library/cpp/string_utils/secret_string/secret_string.h>

#include <util/generic/hash.h>
#include <util/generic/hash_set.h>

#include <map>
#include <memory>
#include <set>

namespace NPassport::NAuth {
    struct TGammaKeeperSettings {
        using TGammas = THashMap<TGammaId, TGamma>;
        using TSignedTypes = std::set<EEnitityType>;
        using TKeyspaces = THashMap<TString, EEnitityType>;
        using TTimeBound = std::map<EEnitityType, TInstant>;

    public:
        TGammas Gammas;
        TSignedTypes SignedTypes;
        TGammaId SigningGamma = 0;
        TKeyspaces KeyspaceToType;
        TTimeBound AllowToCheckWithoutGammaCreatedBefore;
    };

    class TGammaKeeper;
    using TGammaKeeperPtr = std::shared_ptr<TGammaKeeper>;

    class TGammaKeeper {
    public:
        TGammaKeeper(TGammaKeeperSettings&& settings = {});

        static TGammaKeeperPtr Create(TGammaKeeperSettings&& settings = {});

        TKeyWithGamma GetForSign(const TStringBuf keyspace,
                                 const TRandom& random,
                                 const TRandom::EView randomView) const;
        TKeyWithGamma GetForCheck(const TStringBuf keyspace,
                                  const TRandom& random,
                                  const TGammaId gammaId,
                                  const TRandom::EView randomView) const;

    private:
        static void InitGammasHashes(TGammaKeeperSettings::TGammas& gammas);
        void InitSigning(const TGammaKeeperSettings& settings);
        void InitChecking(const TGammaKeeperSettings& settings);

    private:
        THashSet<TString> SignedKeyspaces_;
        TGamma SigningGamma_;

        TGammaKeeperSettings Settings_;
    };
}
