#include "key_with_gamma.h"

#include "gamma.h"
#include "gamma_keeper.h"

namespace NPassport::NAuth {
    TKeyWithGamma::TKeyWithGamma(const TRandom& random, const TGamma& gamma)
        : Body_(MakeXor(*gamma.Body, random.GetBodyHash()))
        , CombinedId_(gamma.Id, random.IntId())
        , ValidUpperBound_(gamma.ValidUpperBound)
    {
    }

    // TODO: drop it when all creds will be enriched with gamma: PASSP-31300
    TKeyWithGamma::TKeyWithGamma(const TRandom& random, TRandom::EView randomView)
        : Body_(random.Get(randomView))
        , CombinedId_(random.IntId())
    {
    }

    TKeyWithGamma::TKeyWithGamma(TString&& error)
        : Err_(std::move(error))
    {
    }

    const TString& TKeyWithGamma::Error() const {
        return Err_;
    }

    const TString& TKeyWithGamma::Body() const {
        Y_ENSURE(Err_.empty(), "incorrect using");
        return Body_;
    }

    TCombinedKeyId TKeyWithGamma::Id() const {
        Y_ENSURE(Err_.empty(), "incorrect using");
        return CombinedId_;
    }

    bool TKeyWithGamma::IsCreateTimeValid(TInstant created) const {
        Y_ENSURE(Err_.empty(), "incorrect using");
        return ValidUpperBound_ ? created < ValidUpperBound_
                                : true;
    }

    void TKeyWithGamma::SetValidUpperBound(TInstant upperBound) {
        Y_ENSURE(Err_.empty(), "incorrect using");
        ValidUpperBound_ = upperBound;
    }

    void TKeyWithGamma::Update(const TRandom& random, TRandom::EView randomView) {
        Y_ENSURE(Err_.empty(), "incorrect using");
        Body_ = MakeXor(Body_, random.Get(randomView));
    }

    TString TKeyWithGamma::MakeXor(const TStringBuf left, const TStringBuf right) {
        Y_ENSURE(left.size() == right.size(),
                 "args have unequal size: left has " << left.size() << ", right has " << right.size());

        TString res(left.size(), 0);
        for (size_t idx = 0; idx < left.size(); ++idx) {
            res[idx] = left[idx] ^ right[idx];
        }

        return res;
    }
}
